/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import net.bivrik.fancytoasts.client.gui.ToastConfigScreen;
import net.bivrik.fancytoasts.client.toast.registry.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.registry.ToastTextureRegistry;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum SettingType {
    TEXTURES("textures"){

        @Override
        void apply(ToastConfigScreen instance, ResourceLocation id) {
            instance.getConfigData().setTextureId(id);
        }

        @Override
        DisplayData getDisplayData(ResourceLocation id) {
            return ToastTextureRegistry.getData(id);
        }

        @Override
        ResourceLocation getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getTextureId();
        }

        @Override
        ResourceLocation[] getKeySet() {
            return ToastTextureRegistry.getIds().toArray(new ResourceLocation[0]);
        }
    }
    ,
    ANIMATIONS("animations"){

        @Override
        void apply(ToastConfigScreen instance, ResourceLocation id) {
            instance.getConfigData().setAnimationId(id);
        }

        @Override
        DisplayData getDisplayData(ResourceLocation id) {
            return ToastAnimationRegistry.getData(id);
        }

        @Override
        ResourceLocation getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getAnimationId();
        }

        @Override
        ResourceLocation[] getKeySet() {
            return ToastAnimationRegistry.getIds().toArray(new ResourceLocation[0]);
        }
    }
    ,
    SOUNDS("sounds"){

        @Override
        void apply(ToastConfigScreen instance, ResourceLocation id) {
            instance.getConfigData().putSound(instance.getAdvancementType(), id);
        }

        @Override
        DisplayData getDisplayData(ResourceLocation id) {
            return new DisplayData((Component)Component.translatable((String)id.toLanguageKey()), "Minecraft", (Component)Component.translatable((String)"fancytoasts.sound.minecraft.description"));
        }

        @Override
        ResourceLocation getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getSoundId(instance.getAdvancementType());
        }

        @Override
        ResourceLocation[] getKeySet() {
            return BuiltInRegistries.SOUND_EVENT.keySet().toArray(new ResourceLocation[0]);
        }
    };

    private final String name;

    abstract void apply(ToastConfigScreen var1, ResourceLocation var2);

    abstract DisplayData getDisplayData(ResourceLocation var1);

    abstract ResourceLocation getCurrentId(ToastConfigScreen var1);

    abstract ResourceLocation[] getKeySet();

    private SettingType(String name) {
        this.name = name;
    }

    public static Component getDisplayName(SettingType type) {
        return Component.translatable((String)("fancytoasts.gui.label." + type.name));
    }
}

