/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.Objects;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.gui.InformationList;
import net.bivrik.fancytoasts.client.gui.ResourceLocationList;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ToastConfigScreen
extends Screen {
    private final Screen parent;
    private final ToastConfigData toastConfigData;
    private SettingType settingType = SettingType.TEXTURES;
    private AdvancementType advancementType = AdvancementType.TASK;
    private DisplayData displayData = this.settingType.getDisplayData(Common.getConfigManager().getToastConfig().getTextureId());
    private Button doneButton;
    private Button backButton;
    private CycleButton<SettingType> settingTypeCycleButton;
    private CycleButton<AdvancementType> advancementTypeCycleButton;
    private EditBox editBox;
    private ResourceLocationList resLocList;
    private InformationList infoList;

    public ToastConfigScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
        this.toastConfigData = Common.getConfigManager().getToastConfig();
        ConfigTextureManager.reload();
    }

    public AdvancementType getAdvancementType() {
        return this.advancementType;
    }

    public ToastConfigData getConfigData() {
        return this.toastConfigData;
    }

    protected void init() {
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.done()).bounds(this.width / 2 + 100 - 125 + 4, this.height - 26, 150, 20).build());
        this.backButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> this.toParentScreen()).bounds(this.width / 2 - 125 - 4, this.height - 20 - 6, 100, 20).build());
        this.settingTypeCycleButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(SettingType::getDisplayName).displayOnlyValue().withValues((Object[])SettingType.values()).withInitialValue((Object)this.settingType).withTooltip(settingType -> switch (settingType) {
            case SettingType.TEXTURES -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.textures"));
            case SettingType.ANIMATIONS -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.animations"));
            case SettingType.SOUNDS -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.sounds"));
            default -> throw new MatchException(null, null);
        }).create(this.width - 128, 32, 120, 20, (Component)Component.empty(), (button, value) -> this.setSettingType((SettingType)((Object)value))));
        this.advancementTypeCycleButton = CycleButton.builder(this::getAdvancementTypeDisplayName).displayOnlyValue().withValues((Object[])AdvancementType.values()).withInitialValue((Object)this.advancementType).withTooltip(advancementType -> switch (advancementType) {
            case AdvancementType.TASK -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.task"));
            case AdvancementType.GOAL -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.goal"));
            case AdvancementType.CHALLENGE -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.challenge"));
            default -> throw new MatchException(null, null);
        }).create(8, 32, 120, 20, (Component)Component.empty(), (button, value) -> this.setAdvancementType((AdvancementType)value));
        this.resLocList = (ResourceLocationList)this.addRenderableWidget((GuiEventListener)new ResourceLocationList(this.minecraft, this.width / 2 + 60 - 8, this.height - 20 - 8 - 64 - 2, this.width / 2 - 60, 60, 18, this.settingType));
        this.resLocList.setAcceptResponder(this::onAcceptedEntry);
        this.resLocList.setSelectResponder(this::onSelectedEntry);
        this.infoList = (InformationList)this.addRenderableWidget((GuiEventListener)new InformationList(this.minecraft, this.width / 2 - 60 - 16, this.height - 20 - 8 - 64 - 2, 8, 60, this.displayData, this.settingType.getCurrentId(this).toLanguageKey().contains("config")));
        this.editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 60, 32, this.width / 2 - 60 - 16, 20, this.editBox, (Component)Component.literal((String)"...")));
        this.editBox.setResponder(this.resLocList::onFilterUpdate);
        this.tryAddAdvancementTypeCycleButton();
    }

    private Component getAdvancementTypeDisplayName(AdvancementType type) {
        return Component.translatable((String)("fancytoasts.gui.label." + type.getSerializedName()));
    }

    private void done() {
        ConfigHandler.save(this.toastConfigData);
        this.toParentScreen();
    }

    private void toParentScreen() {
        ResourceLocation textureId = this.toastConfigData.getTextureId();
        if (textureId.toLanguageKey().contains("config")) {
            ConfigTextureManager.registerInMinecraft(textureId);
        }
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    private void setSettingType(SettingType type) {
        this.settingType = type;
        this.editBox.setValue("");
        this.resLocList.setResourceLocations(this.settingType);
        this.tryAddAdvancementTypeCycleButton();
    }

    private void tryAddAdvancementTypeCycleButton() {
        if (this.settingType == SettingType.SOUNDS) {
            this.advancementType = AdvancementType.TASK;
            this.advancementTypeCycleButton.setValue((Object)this.advancementType);
            this.addRenderableWidget((GuiEventListener)this.advancementTypeCycleButton);
        } else {
            this.removeWidget((GuiEventListener)this.advancementTypeCycleButton);
        }
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).toLanguageKey().contains("config"));
    }

    private void setAdvancementType(AdvancementType type) {
        this.advancementType = type;
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).toLanguageKey().contains("config"));
    }

    public void onClose() {
        this.toParentScreen();
    }

    private void onAcceptedEntry(ResourceLocation location) {
        this.settingType.apply(this, location);
        this.infoList.update(this.displayData, this.settingType.getCurrentId(this).toLanguageKey().contains("config"));
    }

    private void onSelectedEntry(ResourceLocation location) {
        this.displayData = this.settingType.getDisplayData(location);
        this.infoList.update(this.displayData, location.toLanguageKey().contains("config"));
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 12, -1);
    }
}

