/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Deque;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.renderer.GUIHelper;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.IAdvancementAccessor;
import net.bivrik.fancytoasts.platform.Services;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ToastComponent.class})
public class ToastManagerMixin {
    @Shadow
    @Final
    Minecraft minecraft;
    @Unique
    private static final Deque<FancyAdvancementToast> ADVANCEMENT_TOASTS = new ArrayDeque<FancyAdvancementToast>();
    @Unique
    private FancyAdvancementToast fancyToasts$current;
    @Unique
    private long fancyToasts$startTime;

    @Inject(at={@At(value="HEAD")}, method={"addToast"}, cancellable=true)
    private void onAddToast(Toast toast, CallbackInfo info) {
        if (toast instanceof AdvancementToast) {
            info.cancel();
            Advancement advancement = ((IAdvancementAccessor)toast).getAdvancementHolder().value();
            ToastConfigData config = Common.getConfigManager().getToastConfig();
            FancyAdvancementToast fancyAdvancement = new FancyAdvancementToast(advancement, config.getTextureId(), config.getAnimationId());
            ADVANCEMENT_TOASTS.add(fancyAdvancement);
            if (Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
                Services.PLATFORM.tryDisableJade();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    private void onRender(GuiGraphics graphics, CallbackInfo info) {
        if (this.minecraft.options.hideGui) {
            return;
        }
        if (this.fancyToasts$current == null) {
            if (!ADVANCEMENT_TOASTS.isEmpty()) {
                this.fancyToasts$setCurrentAdvancement();
            } else if (!Services.PLATFORM.isJadeEnabled() && Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
                Services.PLATFORM.tryEnableJade();
            }
            return;
        }
        if (!this.fancyToasts$updateCurrentAdvancement()) {
            return;
        }
        int xPos = graphics.guiWidth() / 2 - this.fancyToasts$current.getWidth() / 2;
        PoseStack matrix = GUIHelper.get(graphics);
        GUIHelper.push(matrix);
        GUIHelper.translate(matrix, xPos, 20.0f, 800.0f);
        this.fancyToasts$current.draw(graphics, this.minecraft);
        GUIHelper.pop(matrix);
    }

    @Unique
    private void fancyToasts$setCurrentAdvancement() {
        this.fancyToasts$current = ADVANCEMENT_TOASTS.getFirst();
        ADVANCEMENT_TOASTS.removeFirst();
        this.fancyToasts$current.playSounds(this.minecraft.getSoundManager());
        this.fancyToasts$startTime = Util.getMillis();
    }

    @Unique
    private boolean fancyToasts$updateCurrentAdvancement() {
        if (this.fancyToasts$current.isEnded()) {
            this.fancyToasts$current = null;
            return false;
        }
        long time = Util.getMillis() - this.fancyToasts$startTime;
        this.fancyToasts$current.update(time);
        return true;
    }

    @Inject(at={@At(value="HEAD")}, method={"clear"})
    private void onClear(CallbackInfo info) {
        ADVANCEMENT_TOASTS.clear();
        this.fancyToasts$current = null;
    }
}

