/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.net.URI;
import java.util.Objects;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.gui.GeneralConfigScreen;
import net.bivrik.fancytoasts.client.gui.ToastConfigScreen;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class FancyToastConfigScreen
extends Screen {
    private final Screen parent;
    private final String splash;
    private Button toastConfigButton;
    private Button generalConfigButton;
    private Button backButton;

    public FancyToastConfigScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
        this.splash = Common.getSplashManager().getSplash();
    }

    protected void init() {
        int xCenter = this.width / 2;
        int yCenter = this.height / 2;
        int halfButtonWidth = 75;
        this.backButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> this.toParentScreen()).bounds(xCenter - halfButtonWidth, this.height - 20 - 6, 150, 20).build());
        this.toastConfigButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fancytoasts.gui.label.toast_settings"), button -> this.openToastConfigScreen()).bounds(xCenter - halfButtonWidth, yCenter - 20 - 4, 150, 20).build());
        this.generalConfigButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"fancytoasts.gui.label.general_settings"), button -> this.openGeneralConfigScreen()).bounds(xCenter - halfButtonWidth, yCenter + 4, 150, 20).build());
        MutableComponent supportText = Component.translatable((String)"fancytoasts.gui.support");
        int textWidth = this.font.width((FormattedText)supportText) + 1;
        this.addRenderableWidget((GuiEventListener)new PlainTextButton(this.width - textWidth, this.height - 10, textWidth, 10, (Component)supportText, ConfirmLinkScreen.confirmLink((Screen)this, (URI)URI.create("https://boosty.to/bivrik")), this.font));
    }

    private void openToastConfigScreen() {
        Objects.requireNonNull(this.minecraft).setScreen((Screen)new ToastConfigScreen((Component)Component.translatable((String)"fancytoasts.gui.config.customization_title"), this));
    }

    private void openGeneralConfigScreen() {
        Objects.requireNonNull(this.minecraft).setScreen((Screen)new GeneralConfigScreen((Component)Component.translatable((String)"fancytoasts.gui.config.general_title"), this));
    }

    private void toParentScreen() {
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    public void onClose() {
        this.toParentScreen();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushPose();
        double size = Math.abs(Math.cos((double)Util.getMillis() / 250.0) * (double)0.1f) + (double)0.9f;
        guiGraphics.pose().translate((float)this.width / 2.0f, 25.5f, 0.0f);
        guiGraphics.pose().scale((float)size, (float)size, (float)size);
        guiGraphics.pose().translate((float)this.width / -2.0f, -25.5f, 0.0f);
        guiGraphics.drawCenteredString(this.font, this.splash, this.width / 2, 21, -256);
        guiGraphics.pose().popPose();
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 12, -1);
    }
}

