/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import java.util.Objects;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.client.toast.registry.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.texture.TextureUV;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class FancyAdvancementToast {
    private static final int WIDTH = 162;
    private static final int HEIGHT = 70;
    private final FancyAdvancementToastAnimation animation;
    private final ResourceLocation toastSoundId;
    private final float volume;
    private SoundManager soundManager;
    private boolean isEnded = false;
    private long time;
    private int playedSoundsCount = 0;

    public FancyAdvancementToast(Advancement advancement, ResourceLocation texture, ResourceLocation animationId) {
        DisplayInfo display = advancement.display().orElse(null);
        this.animation = ToastAnimationRegistry.getAnimation(animationId).get();
        switch (Objects.requireNonNull(display).getType()) {
            case TASK: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.TASK_FRAME_UV, display, -256, -1));
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(AdvancementType.TASK);
                this.volume = Common.getConfigManager().getGeneralConfig().getTaskVolume();
                break;
            }
            case GOAL: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.GOAL_FRAME_UV, display, 65535, -1));
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(AdvancementType.GOAL);
                this.volume = Common.getConfigManager().getGeneralConfig().getGoalVolume();
                break;
            }
            case CHALLENGE: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.CHALLENGE_FRAME_UV, display, 15351039, 65535));
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(AdvancementType.CHALLENGE);
                this.volume = Common.getConfigManager().getGeneralConfig().getChallengeVolume();
                break;
            }
            default: {
                throw new RuntimeException("Could match correct advancement type");
            }
        }
        Debug.info("Created new Fancy Advancement Toast: {}", display.getTitle().getString());
    }

    public void draw(GuiGraphics graphics, Minecraft minecraft) {
        this.animation.draw(graphics, minecraft, this, this.time);
    }

    public void update(long time) {
        this.time = time;
        if (this.time >= (long)this.animation.getDuration()) {
            this.isEnded = true;
        }
        if (!Common.getConfigManager().getGeneralConfig().areSoundsEnabled()) {
            return;
        }
        int timeInSeconds = (int)(this.time / 50L);
        if (this.playedSoundsCount == 0 && timeInSeconds == this.animation.getToastSoundTiming() / 50) {
            this.soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(this.toastSoundId)), (float)1.0f, (float)this.volume));
            ++this.playedSoundsCount;
        }
        if (this.playedSoundsCount == 1 && timeInSeconds == this.animation.getDuration() / 50 - 10) {
            this.soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_TOAST_IN, (float)1.0f, (float)1.5f));
            ++this.playedSoundsCount;
        }
    }

    public void playSounds(SoundManager manager) {
        if (!Common.getConfigManager().getGeneralConfig().areSoundsEnabled()) {
            return;
        }
        this.soundManager = manager;
        this.soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_TOAST_IN, (float)1.0f, (float)1.5f));
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 70;
    }
}

