/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.bivrik.fancytoasts.client.renderer.GUIHelper;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.utility.Colors;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class PlayfulAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(1000, 0);
    private static final Appearance ICON_MOVEMENT = new Appearance(1500, 1000);
    private static final Appearance BANNER_APPEARANCE = new Appearance(1000, 1500);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private static final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private static final int FADE_OUT_DURATION = 1500;
    private static final int DURATION = 7500;

    @Override
    public void draw(GuiGraphics graphics, Minecraft minecraft, FancyAdvancementToast fancyToast, long time) {
        float rotation;
        float scale;
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float iconMovementProgress = ICON_MOVEMENT.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 1500, 6000);
        FancyAdvancementSetup setup = this.getSetup();
        PoseStack pose = GUIHelper.get(graphics);
        float sinY = (float)Math.sin((double)time / 400.0) - 3.0f;
        if (fadeOutProgress > 0.0f) {
            float fadeOutScale = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            float toastCenterX = (float)fancyToast.getWidth() / 2.0f;
            float toastCenterY = (float)fancyToast.getHeight() / 2.0f;
            GUIHelper.push(pose);
            GUIHelper.translate(pose, toastCenterX, toastCenterY);
            GUIHelper.scale(pose, fadeOutScale);
            GUIHelper.translate(pose, -toastCenterX, -toastCenterY);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (backgroundAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, backgroundAppearProgress);
                rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, backgroundAppearProgress);
                int y = MathEasing.easeOutLerp(-20, 0, backgroundAppearProgress);
                GUIHelper.translate(pose, 76.0f, 0.0f);
                GUIHelper.scale(pose, scale);
                GUIHelper.rotate(pose, rotation);
                GUIHelper.translate(pose, -76.0f, 0.0f);
                GUIHelper.translate(pose, 0.0f, y);
            }
            this.drawBackground(graphics);
            GUIHelper.pop(pose);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (bannerAppearProgress != 1.0f) {
                float scaleX = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                GUIHelper.translate(pose, 15.0f, -12.0f);
                GUIHelper.scale(pose, scaleX, 1.0f);
                GUIHelper.translate(pose, -15.0f, 12.0f);
            }
            GUIHelper.translate(pose, 0.0f, sinY);
            this.drawBanner(graphics);
            GUIHelper.pop(pose);
        }
        if (iconAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (iconAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, iconAppearProgress);
                rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, iconAppearProgress);
                GUIHelper.translate(pose, 81.0f, 13.0f);
                GUIHelper.scale(pose, scale);
                GUIHelper.rotate(pose, rotation);
                GUIHelper.translate(pose, -81.0f, -13.0f);
            } else if (iconMovementProgress > 0.0f) {
                float x = MathEasing.easeOutLerp(0.0f, -60.0f, iconMovementProgress);
                GUIHelper.translate(pose, x, 0.0f);
            }
            GUIHelper.translate(pose, 0.0f, sinY - 5.0f);
            this.drawIcon(graphics);
            GUIHelper.pop(pose);
        }
        if (textAppearProgress > 0.0f) {
            List descriptionList;
            int a = Math.clamp((long)Mth.floor((float)(textAppearProgress * 255.0f)), 10, 255);
            int titleColor = Colors.alpha(a, setup.titleColor());
            int toastColor = Colors.alpha(a, setup.toastColor());
            Font font = minecraft.font;
            DisplayInfo display = setup.display();
            List titleList = font.split((FormattedText)display.getTitle(), fancyToast.getWidth() - 16);
            if (!titleList.isEmpty()) {
                FormattedCharSequence titleLine = (FormattedCharSequence)titleList.get(0);
                if (titleList.size() == 1) {
                    graphics.drawCenteredString(font, titleLine, fancyToast.getWidth() / 2, 25, titleColor);
                } else {
                    graphics.drawCenteredString(font, titleLine, fancyToast.getWidth() / 2 - font.width("...") / 2, 25, titleColor);
                    graphics.drawCenteredString(font, "...", 1 + fancyToast.getWidth() / 2 + font.width(titleLine) / 2, 25, titleColor);
                }
            }
            if (!(descriptionList = font.split((FormattedText)display.getDescription(), fancyToast.getWidth() - 16)).isEmpty()) {
                graphics.drawString(font, (FormattedCharSequence)descriptionList.get(0), 8, 38, toastColor);
                if (descriptionList.size() > 1) {
                    FormattedCharSequence descriptionSecondLine = (FormattedCharSequence)descriptionList.get(1);
                    graphics.drawString(font, descriptionSecondLine, 8, 47, toastColor);
                    if (descriptionList.size() > 2) {
                        graphics.drawString(font, "...", 8 + font.width(descriptionSecondLine), 47, toastColor);
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIHelper.pop(pose);
        }
    }

    @Override
    public int getDuration() {
        return 7500;
    }

    @Override
    public int getToastSoundTiming() {
        return TEXT_APPEARANCE.startPoint();
    }
}

