/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.client.toast.animation.StandardAnimation;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.utility.ComponentHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ToastAnimationRegistry {
    private static final Map<ResourceLocation, ToastAnimationHandler> ANIMATIONS = new HashMap<ResourceLocation, ToastAnimationHandler>();

    public static void register(ResourceLocation id, Supplier<FancyAdvancementToastAnimation> animation, String modId, String name, String description) {
        if (ANIMATIONS.containsKey(id)) {
            Debug.error("{} already exists! It needs to be unique", id);
            return;
        }
        Component translatableName = ComponentHelper.getTranslatableToastAnimation(modId, name);
        MutableComponent translatableDescription = Component.translatable((String)description);
        ANIMATIONS.put(id, new ToastAnimationHandler(animation, new DisplayData(translatableName, "Fancy Toasts", (Component)translatableDescription)));
        Debug.info("Registered {}", id);
    }

    public static void register(ResourceLocation id, Supplier<FancyAdvancementToastAnimation> animation, String modId, String name) {
        ToastAnimationRegistry.register(id, animation, modId, name, modId + ".animations.toast." + name + ".description");
    }

    private static ToastAnimationHandler getAnimationHandler(ResourceLocation id) {
        return ANIMATIONS.computeIfAbsent(id, key -> {
            Debug.error("Animation {} is missing", key);
            return new ToastAnimationHandler(StandardAnimation::new, new DisplayData((Component)Component.translatable((String)"fancytoasts.animations.toast.standard"), "Fancy Toasts", (Component)Component.translatable((String)"fancytoasts.animations.toast.standard.description")));
        });
    }

    public static boolean isRegistered(ResourceLocation id) {
        return ANIMATIONS.getOrDefault(id, null) != null;
    }

    public static DisplayData getData(ResourceLocation id) {
        return ToastAnimationRegistry.getAnimationHandler((ResourceLocation)id).data;
    }

    public static Component getAnimationName(ResourceLocation id) {
        return ToastAnimationRegistry.getAnimationHandler((ResourceLocation)id).data.getName();
    }

    public static Supplier<FancyAdvancementToastAnimation> getAnimation(ResourceLocation id) {
        return ToastAnimationRegistry.getAnimationHandler((ResourceLocation)id).animationFactory;
    }

    public static Collection<ResourceLocation> getIds() {
        return ANIMATIONS.keySet();
    }

    public record ToastAnimationHandler(Supplier<FancyAdvancementToastAnimation> animationFactory, DisplayData data) {
    }
}

