/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.utility;

import net.minecraft.network.chat.Component;

public class ComponentHelper {
    private static final String DEFAULT_ID = "fancytoasts";

    private static Component getTranslatableComponent(String modId, String name, TranslatableType type) {
        StringBuilder translationKey = new StringBuilder(DEFAULT_ID);
        if (modId != null && modId.compareTo(DEFAULT_ID) != 0) {
            translationKey.append(".").append(modId);
        }
        translationKey.append(".").append(type.getName()).append(".toast.").append(name);
        return Component.translatable((String)translationKey.toString());
    }

    public static Component getTranslatableToastTexture(String modId, String name) {
        return ComponentHelper.getTranslatableComponent(modId, name, TranslatableType.TEXTURE);
    }

    public static Component getTranslatableToastAnimation(String modId, String name) {
        return ComponentHelper.getTranslatableComponent(modId, name, TranslatableType.ANIMATION);
    }

    private static enum TranslatableType {
        ANIMATION("animations"),
        TEXTURE("textures");

        private final String name;

        private TranslatableType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

