/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.util.Optional;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.client.config.JsonHelper;
import net.bivrik.fancytoasts.client.util.FileHelper;

public class ConfigHandler {
    private static final File CONFIG_DIR = new File("./config/fancytoasts/");

    private static <T extends ConfigData> T tryGetInstance(Class<T> configDataClass) {
        try {
            return (T)((ConfigData)configDataClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create an instance of " + configDataClass.getSimpleName() + " to get standard data", e);
        }
    }

    public static <T extends ConfigData> T load(Class<T> configDataClass) {
        FileHelper.tryCreateDir(CONFIG_DIR);
        String className = configDataClass.getSimpleName();
        T standardConfigData = ConfigHandler.tryGetInstance(configDataClass);
        File configFile = new File(((ConfigData)standardConfigData).getPath());
        if (JsonHelper.isValid(configFile)) {
            ConfigData data;
            Optional<T> optionalData = JsonHelper.tryToRead(configFile, configDataClass);
            if (optionalData.isPresent() && (data = (ConfigData)optionalData.get()).isValid()) {
                Debug.info("Successfully read config file with following content:");
                Debug.info(data.toString());
                return (T)data;
            }
            Debug.error("Config file {} is not valid or outdated", className);
        } else {
            Debug.error("Config file {} is not found in {}", className, ((ConfigData)standardConfigData).getPath());
        }
        Debug.warn("Loaded standard data for config: {}", className);
        ConfigHandler.save(standardConfigData);
        return standardConfigData;
    }

    public static <T extends ConfigData> void save(T configData) {
        FileHelper.tryCreateDir(CONFIG_DIR);
        File configFile = new File(configData.getPath());
        if (JsonHelper.tryToWrite(configFile, configData)) {
            Debug.info("Config file saved with following content:");
            Debug.info(configData.toString());
            Common.getConfigManager().updateConfig(configData);
        } else {
            Debug.error("Config file {} could not be saved", configData.getClass().getSimpleName());
        }
    }
}

