/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.platform.Services;

public class GeneralConfigData
extends ConfigData {
    private boolean isJadeCompatEnabled;
    private boolean areSoundsEnabled;
    private float taskVolume;
    private float goalVolume;
    private float challengeVolume;

    public GeneralConfigData(boolean isJadeCompatEnabled, boolean areSoundsEnabled, float taskVolume, float goalVolume, float challengeVolume) {
        super("./config/fancytoasts/general.json");
        this.isJadeCompatEnabled = isJadeCompatEnabled;
        this.areSoundsEnabled = areSoundsEnabled;
        this.taskVolume = taskVolume;
        this.goalVolume = goalVolume;
        this.challengeVolume = challengeVolume;
    }

    public GeneralConfigData() {
        super("./config/fancytoasts/general.json");
        this.isJadeCompatEnabled = true;
        this.areSoundsEnabled = true;
        this.taskVolume = 1.0f;
        this.goalVolume = 1.0f;
        this.challengeVolume = 1.0f;
    }

    public boolean isJadeCompatEnabled() {
        return this.isJadeCompatEnabled;
    }

    public void setJadeCompatEnabled(boolean isJadeCompatibility) {
        this.isJadeCompatEnabled = isJadeCompatibility;
        if (!this.isJadeCompatEnabled) {
            Services.PLATFORM.tryEnableJade();
        }
    }

    public boolean areSoundsEnabled() {
        return this.areSoundsEnabled;
    }

    public void setSoundsEnabled(boolean areSoundsEnabled) {
        this.areSoundsEnabled = areSoundsEnabled;
    }

    public float getTaskVolume() {
        return Math.clamp(this.taskVolume, 0.0f, 2.0f);
    }

    public void setTaskVolume(float taskVolume) {
        this.taskVolume = taskVolume;
    }

    public float getGoalVolume() {
        return Math.clamp(this.goalVolume, 0.0f, 2.0f);
    }

    public void setGoalVolume(float goalVolume) {
        this.goalVolume = goalVolume;
    }

    public float getChallengeVolume() {
        return Math.clamp(this.challengeVolume, 0.0f, 2.0f);
    }

    public void setChallengeVolume(float challengeVolume) {
        this.challengeVolume = challengeVolume;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public GeneralConfigData get() {
        return new GeneralConfigData(this.isJadeCompatEnabled, this.areSoundsEnabled, this.taskVolume, this.goalVolume, this.challengeVolume);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("isJadeCompatibility='%s', areSoundsEnabled='%s', taskVolume='%s', goalVolume='%s', challengeVolume='%s'}", this.isJadeCompatEnabled, this.areSoundsEnabled, Float.valueOf(this.taskVolume), Float.valueOf(this.goalVolume), Float.valueOf(this.challengeVolume));
    }
}

