/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Optional;
import net.bivrik.fancytoasts.Debug;
import net.minecraft.class_2960;

public class JsonHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new ResourceLocationAdapter()).create();

    public static <T> Optional<T> tryToRead(File jsonFile, Class<T> toClass) {
        Optional<Object> optional;
        FileReader reader = new FileReader(jsonFile);
        try {
            optional = Optional.of(GSON.fromJson((Reader)reader, toClass));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Debug.error("Could not read json file {}: {}", jsonFile.getName(), e.getMessage());
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public static boolean tryToWrite(File jsonFile, Object fromClass) {
        try (FileWriter writer = new FileWriter(jsonFile);){
            GSON.toJson(fromClass, (Appendable)writer);
        }
        catch (Exception e) {
            Debug.error("Could not write json file {}: {}", jsonFile.getName(), e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean isValid(File jsonFile) {
        return jsonFile.exists() && jsonFile.length() > 0L;
    }

    private static class ResourceLocationAdapter
    implements JsonSerializer<class_2960>,
    JsonDeserializer<class_2960> {
        private ResourceLocationAdapter() {
        }

        public class_2960 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return class_2960.method_60654((String)json.getAsString());
        }

        public JsonElement serialize(class_2960 src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

