/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.toast.registry.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.registry.ToastTextureRegistry;
import net.bivrik.fancytoasts.client.util.DefaultLocations;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_7923;

public class ToastConfigData
extends ConfigData {
    private class_2960 animationId;
    private class_2960 textureId;
    private final Map<class_189, class_2960> soundIds = new EnumMap<class_189, class_2960>(class_189.class);

    public ToastConfigData(class_2960 animationId, class_2960 textureId, Map<class_189, class_2960> soundIds) {
        super("./config/fancytoasts/toast.json");
        this.animationId = animationId;
        this.textureId = textureId;
        this.soundIds.putAll(soundIds);
    }

    public ToastConfigData() {
        super("./config/fancytoasts/toast.json");
        this.animationId = DefaultLocations.Animations.STANDARD;
        this.textureId = DefaultLocations.Textures.VANILLA;
        this.soundIds.putAll(Map.of(class_189.field_1254, class_3417.field_38365.method_14833(), class_189.field_1249, class_3417.field_14882.method_14833(), class_189.field_1250, class_3417.field_15195.method_14833()));
    }

    public class_2960 getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(class_2960 id) {
        this.animationId = id;
    }

    public class_2960 getTextureId() {
        return this.textureId;
    }

    public void setTextureId(class_2960 id) {
        this.textureId = id;
    }

    public class_2960 getSoundId(class_189 type) {
        return this.soundIds.get(type);
    }

    public void putSound(class_189 type, class_2960 location) {
        this.soundIds.put(type, location);
    }

    @Override
    public String getPath() {
        File oldPathConfigFile = new File("./config/fancytoasts/standard.json");
        oldPathConfigFile.delete();
        return super.getPath();
    }

    @Override
    public boolean isValid() {
        if (ToastTextureRegistry.isRegistered(this.textureId)) {
            if (this.textureId.method_42094().contains("config")) {
                ConfigTextureManager.registerInMinecraft(this.textureId);
            }
        } else {
            return false;
        }
        return ToastAnimationRegistry.isRegistered(this.animationId) && class_7923.field_41172.method_10250(this.getSoundId(class_189.field_1254)) && class_7923.field_41172.method_10250(this.getSoundId(class_189.field_1249)) && class_7923.field_41172.method_10250(this.getSoundId(class_189.field_1250));
    }

    @Override
    public ToastConfigData get() {
        return new ToastConfigData(this.animationId, this.textureId, this.soundIds);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("animationId='%s', textureId='%s', soundIds='%s'}", this.animationId, this.textureId, this.soundIds);
    }
}

