/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_8494;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationList
extends class_4280<Entry> {
    private class_2960[] resourceLocations;
    private SettingType settingType;
    private Consumer<class_2960> acceptResponder;
    private Consumer<class_2960> selectResponder;

    public ResourceLocationList(class_310 minecraft, int width, int height, int x, int y, int itemHeight, SettingType settingType) {
        super(minecraft, width, height, y, itemHeight);
        this.method_46421(x);
        this.setResourceLocations(settingType);
    }

    public void setAcceptResponder(Consumer<class_2960> acceptResponder) {
        this.acceptResponder = acceptResponder;
    }

    public void setSelectResponder(Consumer<class_2960> selectResponder) {
        this.selectResponder = selectResponder;
    }

    public int method_25322() {
        return this.field_22758 - 6 - 16;
    }

    public int method_25342() {
        return this.method_46426() + this.field_22758 / 2 - this.method_25322() / 2 + 4;
    }

    protected int method_25329() {
        return this.method_46426() + this.field_22758 - 8;
    }

    public void onFilterUpdate(String filter) {
        this.clear();
        filter = filter.toLowerCase(Locale.ROOT);
        for (class_2960 location : this.resourceLocations) {
            if (!this.settingType.getDisplayData(location).getName().getString().toLowerCase(Locale.ROOT).contains(filter)) continue;
            this.method_25321((class_350.class_351)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    public void setResourceLocations(SettingType settingType) {
        this.settingType = settingType;
        this.resourceLocations = this.settingType.getKeySet();
        this.refillList();
    }

    private void refillList() {
        this.clear();
        for (class_2960 location : this.resourceLocations) {
            this.method_25321((class_350.class_351)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    private void clear() {
        this.method_25339();
        this.method_25307(0.0);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Entry selectedEntry;
        if (class_8494.method_51255((int)keyCode) && (selectedEntry = (Entry)this.method_25334()) instanceof ResourceLocationListEntry) {
            ((ResourceLocationListEntry)selectedEntry).accept();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private static final class ResourceLocationListEntry
    extends Entry {
        private final class_2960 location;
        private final class_310 minecraft;
        private final class_327 font;
        private final ResourceLocationList list;
        private final List<class_5481> nameList;
        private long lastClickTime;

        public ResourceLocationListEntry(ResourceLocationList list, class_2960 location, class_2561 name) {
            this.list = list;
            this.location = location;
            this.minecraft = this.list.field_22740;
            this.font = this.minecraft.field_1772;
            this.nameList = this.font.method_1728((class_5348)name, this.list.method_25322() - 8 - 2);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (class_156.method_658() - this.lastClickTime >= 250L) {
                this.lastClickTime = class_156.method_658();
                this.select();
            } else {
                this.accept();
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        private void select() {
            if (this.list.selectResponder != null) {
                this.list.selectResponder.accept(this.location);
            } else {
                Debug.error("There is no select responder for Resource Location List. Could not select location: " + String.valueOf(this.location));
            }
        }

        private void accept() {
            if (this.list.acceptResponder != null) {
                this.list.acceptResponder.accept(this.location);
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            } else {
                Debug.error("There is no accept responder for Resource Location List. Could not accept location: " + String.valueOf(this.location));
            }
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.nameList.size() == 1) {
                guiGraphics.method_35720(this.font, this.nameList.getFirst(), x, y + 3, -1);
            } else {
                guiGraphics.method_35720(this.font, this.nameList.get(1), x, y + 6, -6250336);
                guiGraphics.method_35720(this.font, this.nameList.get(0), x, y, -1);
            }
        }
    }

    protected static abstract class Entry
    extends class_4280.class_4281<Entry> {
        protected Entry() {
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43473();
        }
    }
}

