/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.Objects;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.gui.InformationList;
import net.bivrik.fancytoasts.client.gui.ResourceLocationList;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.minecraft.class_189;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ToastConfigScreen
extends class_437 {
    private final class_437 parent;
    private final ToastConfigData toastConfigData;
    private SettingType settingType = SettingType.TEXTURES;
    private class_189 advancementType = class_189.field_1254;
    private DisplayData displayData = this.settingType.getDisplayData(Common.getConfigManager().getToastConfig().getTextureId());
    private class_4185 doneButton;
    private class_4185 backButton;
    private class_5676<SettingType> settingTypeCycleButton;
    private class_5676<class_189> advancementTypeCycleButton;
    private class_342 editBox;
    private ResourceLocationList resLocList;
    private InformationList infoList;

    public ToastConfigScreen(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
        this.toastConfigData = Common.getConfigManager().getToastConfig();
        ConfigTextureManager.reload();
    }

    public class_189 getAdvancementType() {
        return this.advancementType;
    }

    public ToastConfigData getConfigData() {
        return this.toastConfigData;
    }

    protected void method_25426() {
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.done()).method_46434(this.field_22789 / 2 + 100 - 125 + 4, this.field_22790 - 26, 150, 20).method_46431());
        this.backButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.toParentScreen()).method_46434(this.field_22789 / 2 - 125 - 4, this.field_22790 - 20 - 6, 100, 20).method_46431());
        this.settingTypeCycleButton = (class_5676)this.method_37063((class_364)class_5676.method_32606(SettingType::getDisplayName).method_32616().method_32624((Object[])SettingType.values()).method_32619((Object)this.settingType).method_32618(settingType -> switch (settingType) {
            case SettingType.TEXTURES -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancytoasts.gui.tooltip.textures"));
            case SettingType.ANIMATIONS -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancytoasts.gui.tooltip.animations"));
            case SettingType.SOUNDS -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancytoasts.gui.tooltip.sounds"));
            default -> throw new MatchException(null, null);
        }).method_32617(this.field_22789 - 128, 32, 120, 20, (class_2561)class_2561.method_43473(), (button, value) -> this.setSettingType((SettingType)((Object)value))));
        this.advancementTypeCycleButton = class_5676.method_32606(this::getAdvancementTypeDisplayName).method_32616().method_32624((Object[])class_189.values()).method_32619((Object)this.advancementType).method_32618(advancementType -> switch (advancementType) {
            case class_189.field_1254 -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancytoasts.gui.tooltip.task"));
            case class_189.field_1249 -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancytoasts.gui.tooltip.goal"));
            case class_189.field_1250 -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancytoasts.gui.tooltip.challenge"));
            default -> throw new MatchException(null, null);
        }).method_32617(8, 32, 120, 20, (class_2561)class_2561.method_43473(), (button, value) -> this.setAdvancementType((class_189)value));
        this.resLocList = (ResourceLocationList)this.method_37063((class_364)new ResourceLocationList(this.field_22787, this.field_22789 / 2 + 60 - 8, this.field_22790 - 20 - 8 - 64 - 2, this.field_22789 / 2 - 60, 60, 18, this.settingType));
        this.resLocList.setAcceptResponder(this::onAcceptedEntry);
        this.resLocList.setSelectResponder(this::onSelectedEntry);
        this.infoList = (InformationList)this.method_37063((class_364)new InformationList(this.field_22787, this.field_22789 / 2 - 60 - 16, this.field_22790 - 20 - 8 - 64 - 2, 8, 60, this.displayData, this.settingType.getCurrentId(this).method_42094().contains("config")));
        this.editBox = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 60, 32, this.field_22789 / 2 - 60 - 16, 20, this.editBox, (class_2561)class_2561.method_43470((String)"...")));
        this.editBox.method_1863(this.resLocList::onFilterUpdate);
        this.tryAddAdvancementTypeCycleButton();
    }

    private class_2561 getAdvancementTypeDisplayName(class_189 type) {
        return class_2561.method_43471((String)("fancytoasts.gui.label." + type.method_15434()));
    }

    private void done() {
        ConfigHandler.save(this.toastConfigData);
        this.toParentScreen();
    }

    private void toParentScreen() {
        class_2960 textureId = this.toastConfigData.getTextureId();
        if (textureId.method_42094().contains("config")) {
            ConfigTextureManager.registerInMinecraft(textureId);
        }
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    private void setSettingType(SettingType type) {
        this.settingType = type;
        this.editBox.method_1852("");
        this.resLocList.setResourceLocations(this.settingType);
        this.tryAddAdvancementTypeCycleButton();
    }

    private void tryAddAdvancementTypeCycleButton() {
        if (this.settingType == SettingType.SOUNDS) {
            this.advancementType = class_189.field_1254;
            this.advancementTypeCycleButton.method_32605((Object)this.advancementType);
            this.method_37063((class_364)this.advancementTypeCycleButton);
        } else {
            this.method_37066((class_364)this.advancementTypeCycleButton);
        }
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).method_42094().contains("config"));
    }

    private void setAdvancementType(class_189 type) {
        this.advancementType = type;
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).method_42094().contains("config"));
    }

    public void method_25419() {
        this.toParentScreen();
    }

    private void onAcceptedEntry(class_2960 location) {
        this.settingType.apply(this, location);
        this.infoList.update(this.displayData, this.settingType.getCurrentId(this).method_42094().contains("config"));
    }

    private void onSelectedEntry(class_2960 location) {
        this.displayData = this.settingType.getDisplayData(location);
        this.infoList.update(this.displayData, location.method_42094().contains("config"));
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, -1);
    }
}

