/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.List;
import net.bivrik.fancytoasts.client.renderer.GUIHelper;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.utility.Colors;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.class_185;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class PlayfulAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(1000, 0);
    private static final Appearance ICON_MOVEMENT = new Appearance(1500, 1000);
    private static final Appearance BANNER_APPEARANCE = new Appearance(1000, 1500);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private static final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private static final int FADE_OUT_DURATION = 1500;
    private static final int DURATION = 7500;

    @Override
    public void draw(class_332 graphics, class_310 minecraft, FancyAdvancementToast fancyToast, long time) {
        float rotation;
        float scale;
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float iconMovementProgress = ICON_MOVEMENT.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 1500, 6000);
        FancyAdvancementSetup setup = this.getSetup();
        class_4587 pose = GUIHelper.get(graphics);
        float sinY = (float)Math.sin((double)time / 400.0) - 3.0f;
        if (fadeOutProgress > 0.0f) {
            float fadeOutScale = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            float toastCenterX = (float)fancyToast.getWidth() / 2.0f;
            float toastCenterY = (float)fancyToast.getHeight() / 2.0f;
            GUIHelper.push(pose);
            GUIHelper.translate(pose, toastCenterX, toastCenterY);
            GUIHelper.scale(pose, fadeOutScale);
            GUIHelper.translate(pose, -toastCenterX, -toastCenterY);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (backgroundAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, backgroundAppearProgress);
                rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, backgroundAppearProgress);
                int y = MathEasing.easeOutLerp(-20, 0, backgroundAppearProgress);
                GUIHelper.translate(pose, 76.0f, 0.0f);
                GUIHelper.scale(pose, scale);
                GUIHelper.rotate(pose, rotation);
                GUIHelper.translate(pose, -76.0f, 0.0f);
                GUIHelper.translate(pose, 0.0f, y);
            }
            this.drawBackground(graphics);
            GUIHelper.pop(pose);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (bannerAppearProgress != 1.0f) {
                float scaleX = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                GUIHelper.translate(pose, 15.0f, -12.0f);
                GUIHelper.scale(pose, scaleX, 1.0f);
                GUIHelper.translate(pose, -15.0f, 12.0f);
            }
            GUIHelper.translate(pose, 0.0f, sinY);
            this.drawBanner(graphics);
            GUIHelper.pop(pose);
        }
        if (iconAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (iconAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, iconAppearProgress);
                rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, iconAppearProgress);
                GUIHelper.translate(pose, 81.0f, 13.0f);
                GUIHelper.scale(pose, scale);
                GUIHelper.rotate(pose, rotation);
                GUIHelper.translate(pose, -81.0f, -13.0f);
            } else if (iconMovementProgress > 0.0f) {
                float x = MathEasing.easeOutLerp(0.0f, -60.0f, iconMovementProgress);
                GUIHelper.translate(pose, x, 0.0f);
            }
            GUIHelper.translate(pose, 0.0f, sinY - 5.0f);
            this.drawIcon(graphics);
            GUIHelper.pop(pose);
        }
        if (textAppearProgress > 0.0f) {
            List descriptionList;
            int a = Math.clamp((long)class_3532.method_15375((float)(textAppearProgress * 255.0f)), 10, 255);
            int titleColor = Colors.alpha(a, setup.titleColor());
            int toastColor = Colors.alpha(a, setup.toastColor());
            class_327 font = minecraft.field_1772;
            class_185 display = setup.display();
            List titleList = font.method_1728((class_5348)display.method_811(), fancyToast.getWidth() - 16);
            if (!titleList.isEmpty()) {
                class_5481 titleLine = (class_5481)titleList.get(0);
                if (titleList.size() == 1) {
                    graphics.method_35719(font, titleLine, fancyToast.getWidth() / 2, 25, titleColor);
                } else {
                    graphics.method_35719(font, titleLine, fancyToast.getWidth() / 2 - font.method_1727("...") / 2, 25, titleColor);
                    graphics.method_25300(font, "...", 1 + fancyToast.getWidth() / 2 + font.method_30880(titleLine) / 2, 25, titleColor);
                }
            }
            if (!(descriptionList = font.method_1728((class_5348)display.method_817(), fancyToast.getWidth() - 16)).isEmpty()) {
                graphics.method_35720(font, (class_5481)descriptionList.get(0), 8, 38, toastColor);
                if (descriptionList.size() > 1) {
                    class_5481 descriptionSecondLine = (class_5481)descriptionList.get(1);
                    graphics.method_35720(font, descriptionSecondLine, 8, 47, toastColor);
                    if (descriptionList.size() > 2) {
                        graphics.method_25303(font, "...", 8 + font.method_30880(descriptionSecondLine), 47, toastColor);
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIHelper.pop(pose);
        }
    }

    @Override
    public int getDuration() {
        return 7500;
    }

    @Override
    public int getToastSoundTiming() {
        return TEXT_APPEARANCE.startPoint();
    }
}

