/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.List;
import java.util.Random;
import net.bivrik.fancytoasts.client.renderer.GUIHelper;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.utility.Colors;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.class_185;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class QuirkyAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private static final Appearance ICON_SCALE = new Appearance(3500, 0);
    private static final Appearance BANNER_APPEARANCE = new Appearance(900, 1200);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(1000, 1000);
    private static final Appearance TEXT_APPEARANCE = new Appearance(1000, 1800);
    private static final int FADE_OUT_DURATION = 1500;
    private static final int DURATION = 6500;
    private static final Random random = new Random();
    private static float randomRotation;

    @Override
    public void setup(FancyAdvancementSetup setup) {
        super.setup(setup);
        randomRotation = random.nextFloat(-0.4f, 0.4f);
    }

    @Override
    public void draw(class_332 graphics, class_310 minecraft, FancyAdvancementToast fancyToast, long time) {
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float iconScaleProgress = ICON_SCALE.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 1500, 5000);
        FancyAdvancementSetup setup = this.getSetup();
        class_4587 pose = GUIHelper.get(graphics);
        float sinX = (float)(Math.sin((double)time / 800.0) * 7.0);
        float sinY = (float)(Math.sin((double)time / 400.0) * 5.0);
        GUIHelper.push(pose);
        GUIHelper.translate(pose, sinX, sinY);
        if (fadeOutProgress > 0.0f) {
            float fadeOutScaleX = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            float fadeOutRotation = MathEasing.easeInLerp(0.0f, randomRotation, fadeOutProgress);
            float toastCenterX = (float)fancyToast.getWidth() / 2.0f;
            float toastCenterY = (float)fancyToast.getHeight() / 2.0f;
            GUIHelper.push(pose);
            GUIHelper.translate(pose, toastCenterX, toastCenterY);
            GUIHelper.scale(pose, fadeOutScaleX);
            GUIHelper.rotate(pose, fadeOutRotation);
            GUIHelper.translate(pose, -toastCenterX, -toastCenterY);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            float y = 32.0f;
            if (bannerAppearProgress != 1.0f) {
                y = MathEasing.easeOutLerp(-40.0f, 32.0f, bannerAppearProgress);
            }
            GUIHelper.translate(pose, 0.0f, y);
            this.drawBanner(graphics);
            GUIHelper.pop(pose);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            int y = -25;
            if (backgroundAppearProgress != 1.0f) {
                y = MathEasing.easeOutLerp(-120, -25, backgroundAppearProgress);
            }
            GUIHelper.translate(pose, 0.0f, y);
            this.drawBackground(graphics);
            GUIHelper.pop(pose);
        }
        if (iconAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            float posY = 29.0f;
            if (iconAppearProgress != 1.0f) {
                posY = MathEasing.easeOutLerp(-120, 29, iconAppearProgress);
            }
            if (iconScaleProgress != 1.0f && iconScaleProgress > 0.0f) {
                float scale = MathEasing.easeOutLerp(3.0f, 1.0f, iconScaleProgress);
                GUIHelper.translate(pose, 81.0f, 17.0f);
                GUIHelper.scale(pose, scale);
                GUIHelper.translate(pose, -81.0f, -17.0f);
            }
            GUIHelper.translate(pose, 0.0f, (float)(Math.sin((double)time / 400.0) * -1.2) + posY);
            this.drawIcon(graphics);
            GUIHelper.pop(pose);
        }
        if (textAppearProgress > 0.0f) {
            int a = Math.clamp((long)class_3532.method_15375((float)(textAppearProgress * 255.0f)), 10, 255);
            int titleColor = Colors.alpha(a, setup.titleColor());
            int toastColor = Colors.alpha(a, setup.toastColor());
            class_327 font = minecraft.field_1772;
            class_185 display = setup.display();
            int toastCenterX = fancyToast.getWidth() / 2;
            graphics.method_27534(font, display.method_815().method_30756(), toastCenterX, 0, titleColor);
            List descriptionList = font.method_1728((class_5348)display.method_817(), fancyToast.getWidth() - 16);
            if (!descriptionList.isEmpty()) {
                graphics.method_35719(font, (class_5481)descriptionList.get(0), toastCenterX, 12, toastColor);
                if (descriptionList.size() > 1) {
                    class_5481 descriptionSecondLine = (class_5481)descriptionList.get(1);
                    if (descriptionList.size() > 2) {
                        graphics.method_35719(font, descriptionSecondLine, toastCenterX - font.method_1727("...") / 2, 21, toastColor);
                        graphics.method_25300(font, "...", toastCenterX + font.method_30880(descriptionSecondLine) / 2, 21, toastColor);
                    } else {
                        graphics.method_35719(font, descriptionSecondLine, toastCenterX, 21, toastColor);
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIHelper.pop(pose);
        }
        GUIHelper.pop(pose);
    }

    @Override
    public int getDuration() {
        return 6500;
    }

    @Override
    public int getToastSoundTiming() {
        return 1000;
    }
}

