/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.List;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.renderer.GUIHelper;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.utility.Colors;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.class_185;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class StandardAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private static final Appearance BANNER_APPEARANCE = new Appearance(500, 1500);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private static final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private static final int FADE_OUT_DURATION = 2000;
    private static final int DURATION = 8000;

    @Override
    public void draw(class_332 graphics, class_310 minecraft, FancyAdvancementToast fancyToast, long time) {
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 2000, 6000);
        FancyAdvancementSetup setup = this.getSetup();
        class_4587 pose = GUIHelper.get(graphics);
        if (fadeOutProgress > 0.0f) {
            float fadeOutY = MathEasing.easeInLerp(0, -80, fadeOutProgress);
            GUIHelper.push(pose);
            GUIHelper.translate(pose, 0.0f, fadeOutY);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (backgroundAppearProgress != 1.0f) {
                int y = MathEasing.easeOutLerp(-200, 0, backgroundAppearProgress);
                GUIHelper.translate(pose, 0.0f, y);
            }
            this.drawBackground(graphics);
            GUIHelper.pop(pose);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (bannerAppearProgress != 1.0f) {
                float xScale = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                GUIHelper.translate(pose, 81.0f, 0.0f);
                GUIHelper.scale(pose, xScale, 1.0f);
                GUIHelper.translate(pose, -81.0f, 0.0f);
            }
            this.drawBanner(graphics);
            GUIHelper.pop(pose);
        }
        if (iconAppearProgress > 0.0f) {
            GUIHelper.push(pose);
            if (iconAppearProgress != 1.0f) {
                int y = MathEasing.easeOutLerp(-100, 0, iconAppearProgress);
                float scale = MathEasing.easeOutLerp(0.0f, 1.0f, iconAppearProgress);
                GUIHelper.translate(pose, 81.0f, 13.0f);
                GUIHelper.scale(pose, scale);
                GUIHelper.translate(pose, -81.0f, -13.0f);
                GUIHelper.translate(pose, 0.0f, y);
            }
            GUIHelper.translate(pose, 0.0f, (float)(Math.sin((float)time / 500.0f) * 1.5) - 5.0f);
            this.drawIcon(graphics);
            GUIHelper.pop(pose);
        }
        if (textAppearProgress > 0.0f) {
            int a = Math.clamp((long)class_3532.method_15375((float)(textAppearProgress * 255.0f)), 10, 255);
            int titleColor = Colors.alpha(a, setup.titleColor());
            int toastColor = Colors.alpha(a, setup.toastColor());
            Debug.info("" + titleColor);
            class_327 font = minecraft.field_1772;
            class_185 display = setup.display();
            graphics.method_27534(font, display.method_815().method_30756(), fancyToast.getWidth() / 2, 25, titleColor);
            List descriptionList = font.method_1728((class_5348)display.method_811(), fancyToast.getWidth() - 20);
            if (!descriptionList.isEmpty()) {
                if (descriptionList.size() == 1) {
                    graphics.method_35719(font, (class_5481)descriptionList.get(0), fancyToast.getWidth() / 2, 43, toastColor);
                } else {
                    int lineHeight = 42 - 9 * (descriptionList.size() - 1) / 2;
                    for (class_5481 text : descriptionList) {
                        graphics.method_35719(font, text, fancyToast.getWidth() / 2, lineHeight, toastColor);
                        lineHeight += 9;
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIHelper.pop(pose);
        }
    }

    @Override
    public int getDuration() {
        return 8000;
    }

    @Override
    public int getToastSoundTiming() {
        return TEXT_APPEARANCE.startPoint();
    }
}

