/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.client.toast.animation.StandardAnimation;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.utility.ComponentHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ToastAnimationRegistry {
    private static final Map<class_2960, ToastAnimationHandler> ANIMATIONS = new HashMap<class_2960, ToastAnimationHandler>();

    public static void register(class_2960 id, Supplier<FancyAdvancementToastAnimation> animation, String modId, String name, String description) {
        if (ANIMATIONS.containsKey(id)) {
            Debug.error("{} already exists! It needs to be unique", id);
            return;
        }
        class_2561 translatableName = ComponentHelper.getTranslatableToastAnimation(modId, name);
        class_5250 translatableDescription = class_2561.method_43471((String)description);
        ANIMATIONS.put(id, new ToastAnimationHandler(animation, new DisplayData(translatableName, "Fancy Toasts", (class_2561)translatableDescription)));
        Debug.info("Registered {}", id);
    }

    public static void register(class_2960 id, Supplier<FancyAdvancementToastAnimation> animation, String modId, String name) {
        ToastAnimationRegistry.register(id, animation, modId, name, modId + ".animations.toast." + name + ".description");
    }

    private static ToastAnimationHandler getAnimationHandler(class_2960 id) {
        return ANIMATIONS.computeIfAbsent(id, key -> {
            Debug.error("Animation {} is missing", key);
            return new ToastAnimationHandler(StandardAnimation::new, new DisplayData((class_2561)class_2561.method_43471((String)"fancytoasts.animations.toast.standard"), "Fancy Toasts", (class_2561)class_2561.method_43471((String)"fancytoasts.animations.toast.standard.description")));
        });
    }

    public static boolean isRegistered(class_2960 id) {
        return ANIMATIONS.getOrDefault(id, null) != null;
    }

    public static DisplayData getData(class_2960 id) {
        return ToastAnimationRegistry.getAnimationHandler((class_2960)id).data;
    }

    public static class_2561 getAnimationName(class_2960 id) {
        return ToastAnimationRegistry.getAnimationHandler((class_2960)id).data.getName();
    }

    public static Supplier<FancyAdvancementToastAnimation> getAnimation(class_2960 id) {
        return ToastAnimationRegistry.getAnimationHandler((class_2960)id).animationFactory;
    }

    public static Collection<class_2960> getIds() {
        return ANIMATIONS.keySet();
    }

    public record ToastAnimationHandler(Supplier<FancyAdvancementToastAnimation> animationFactory, DisplayData data) {
    }
}

