/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.utility.ComponentHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ToastTextureRegistry {
    private static final Map<class_2960, DisplayData> TEXTURES = new HashMap<class_2960, DisplayData>();

    public static boolean register(class_2960 id, String modId, String name, String author, String description) {
        class_5250 translatableDescription;
        class_5250 componentName;
        if (TEXTURES.containsKey(id)) {
            Debug.error("{} already exists! It needs to be unique", id);
            return false;
        }
        if (modId != null) {
            componentName = ComponentHelper.getTranslatableToastTexture(modId, name);
            translatableDescription = class_2561.method_43471((String)description);
        } else {
            componentName = class_2561.method_43470((String)name);
            translatableDescription = class_2561.method_43470((String)description);
        }
        DisplayData data = new DisplayData((class_2561)componentName, author, (class_2561)translatableDescription);
        TEXTURES.put(id, data);
        Debug.info("Registered {}", id);
        return true;
    }

    public static boolean register(class_2960 id, String modId, String name, String author) {
        return ToastTextureRegistry.register(id, modId, name, author, modId + ".textures.toast." + name + ".description");
    }

    public static void clearCustom() {
        ToastTextureRegistry.getIds().removeIf(id -> id.toString().contains("config"));
    }

    public static DisplayData getData(class_2960 id) {
        return TEXTURES.computeIfAbsent(id, key -> {
            Debug.error("Texture {} is missing", key);
            return new DisplayData((class_2561)class_2561.method_43471((String)"fancytoasts.textures.toast.vanilla"), "Fancy Toasts", (class_2561)class_2561.method_43471((String)"fancytoasts.textures.vanilla.description"));
        });
    }

    public static boolean isRegistered(class_2960 id) {
        return TEXTURES.getOrDefault(id, null) != null;
    }

    public static class_2561 getTextureName(class_2960 id) {
        return ToastTextureRegistry.getData(id).getName();
    }

    public static class_2561 getTextureAuthor(class_2960 id) {
        return ToastTextureRegistry.getData(id).getAuthor();
    }

    public static Collection<class_2960> getIds() {
        return TEXTURES.keySet();
    }
}

