/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.mixin;

import java.util.ArrayDeque;
import java.util.Deque;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.renderer.GUIHelper;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.IAdvancementAccessor;
import net.bivrik.fancytoasts.platform.Services;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_367;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_374.class})
public class ToastManagerMixin {
    @Shadow
    @Final
    class_310 field_2238;
    @Unique
    private static final Deque<FancyAdvancementToast> ADVANCEMENT_TOASTS = new ArrayDeque<FancyAdvancementToast>();
    @Unique
    private FancyAdvancementToast fancyToasts$current;
    @Unique
    private long fancyToasts$startTime;

    @Inject(at={@At(value="HEAD")}, method={"addToast"}, cancellable=true)
    private void onAddToast(class_368 toast, CallbackInfo info) {
        if (toast instanceof class_367) {
            info.cancel();
            class_161 advancement = ((IAdvancementAccessor)toast).getAdvancementHolder().comp_1920();
            ToastConfigData config = Common.getConfigManager().getToastConfig();
            FancyAdvancementToast fancyAdvancement = new FancyAdvancementToast(advancement, config.getTextureId(), config.getAnimationId());
            ADVANCEMENT_TOASTS.add(fancyAdvancement);
            if (Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
                Services.PLATFORM.tryDisableJade();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    private void onRender(class_332 graphics, CallbackInfo info) {
        if (this.field_2238.field_1690.field_1842) {
            return;
        }
        if (this.fancyToasts$current == null) {
            if (!ADVANCEMENT_TOASTS.isEmpty()) {
                this.fancyToasts$setCurrentAdvancement();
            } else if (!Services.PLATFORM.isJadeEnabled() && Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
                Services.PLATFORM.tryEnableJade();
            }
            return;
        }
        if (!this.fancyToasts$updateCurrentAdvancement()) {
            return;
        }
        int xPos = graphics.method_51421() / 2 - this.fancyToasts$current.getWidth() / 2;
        class_4587 matrix = GUIHelper.get(graphics);
        GUIHelper.push(matrix);
        GUIHelper.translate(matrix, xPos, 20.0f, 800.0f);
        this.fancyToasts$current.draw(graphics, this.field_2238);
        GUIHelper.pop(matrix);
    }

    @Unique
    private void fancyToasts$setCurrentAdvancement() {
        this.fancyToasts$current = ADVANCEMENT_TOASTS.getFirst();
        ADVANCEMENT_TOASTS.removeFirst();
        this.fancyToasts$current.playSounds(this.field_2238.method_1483());
        this.fancyToasts$startTime = class_156.method_658();
    }

    @Unique
    private boolean fancyToasts$updateCurrentAdvancement() {
        if (this.fancyToasts$current.isEnded()) {
            this.fancyToasts$current = null;
            return false;
        }
        long time = class_156.method_658() - this.fancyToasts$startTime;
        this.fancyToasts$current.update(time);
        return true;
    }

    @Inject(at={@At(value="HEAD")}, method={"clear"})
    private void onClear(CallbackInfo info) {
        ADVANCEMENT_TOASTS.clear();
        this.fancyToasts$current = null;
    }
}

