/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.ToastTextureRegistry;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class ToastConfigData
extends ConfigData {
    private ResourceLocation animationId;
    private ResourceLocation textureId;
    private final Map<AdvancementType, ResourceLocation> soundIds = new EnumMap<AdvancementType, ResourceLocation>(AdvancementType.class);

    public ToastConfigData(ResourceLocation animationId, ResourceLocation textureId, Map<AdvancementType, ResourceLocation> soundIds) {
        super("./config/fancytoasts/toast.json");
        this.animationId = animationId;
        this.textureId = textureId;
        this.soundIds.putAll(soundIds);
    }

    public ToastConfigData() {
        super("./config/fancytoasts/toast.json");
        this.animationId = DefaultLocations.Animations.STANDARD;
        this.textureId = DefaultLocations.Textures.VANILLA;
        this.soundIds.putAll(Map.of(AdvancementType.TASK, SoundEvents.ALLAY_AMBIENT_WITH_ITEM.location(), AdvancementType.GOAL, SoundEvents.FIREWORK_ROCKET_TWINKLE_FAR.location(), AdvancementType.CHALLENGE, SoundEvents.UI_TOAST_CHALLENGE_COMPLETE.location()));
    }

    public ResourceLocation getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(ResourceLocation id) {
        this.animationId = id;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public void setTextureId(ResourceLocation id) {
        this.textureId = id;
    }

    public ResourceLocation getSoundId(AdvancementType type) {
        return this.soundIds.get(type);
    }

    public void putSound(AdvancementType type, ResourceLocation location) {
        this.soundIds.put(type, location);
    }

    @Override
    public String getPath() {
        File oldPathConfigFile = new File("./config/fancytoasts/standard.json");
        oldPathConfigFile.delete();
        return super.getPath();
    }

    @Override
    public boolean isValid() {
        if (ToastTextureRegistry.isRegistered(this.textureId)) {
            if (this.textureId.toLanguageKey().contains("config")) {
                ConfigTextureManager.registerInMinecraft(this.textureId);
            }
        } else {
            return false;
        }
        return ToastAnimationRegistry.isRegistered(this.animationId) && BuiltInRegistries.SOUND_EVENT.containsKey(this.getSoundId(AdvancementType.TASK)) && BuiltInRegistries.SOUND_EVENT.containsKey(this.getSoundId(AdvancementType.GOAL)) && BuiltInRegistries.SOUND_EVENT.containsKey(this.getSoundId(AdvancementType.CHALLENGE));
    }

    @Override
    public ToastConfigData get() {
        return new ToastConfigData(this.animationId, this.textureId, this.soundIds);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("animationId='%s', textureId='%s', soundIds='%s'}", this.animationId, this.textureId, this.soundIds);
    }
}

