/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.animation.entity;

import com.alien.common.gameplay.entity.living.alien.xenomorph.boiler.Boiler;
import com.alien.common.gameplay.entity.living.alien.xenomorph.boiler.BoilerAnimationDispatcher;
import com.avp.AVPResources;
import mod.azure.azurelib.common.animation.AzAnimator;
import mod.azure.azurelib.common.animation.AzAnimatorConfig;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.common.animation.impl.AzEntityAnimator;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BoilerAnimator
extends AzEntityAnimator<Boiler> {
    private static final String NAME = "boiler";
    private static final ResourceLocation ANIMATION = AVPResources.entityAnimationLocation("boiler");

    public BoilerAnimator() {
        super(AzAnimatorConfig.defaultConfig());
    }

    public void registerControllers(AzAnimationControllerContainer<Boiler> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"full_body").setTransitionLength(5).build(), new AzAnimationController[0]);
    }

    @NotNull
    public ResourceLocation getAnimationLocation(Boiler animatable) {
        return ANIMATION;
    }

    public void setCustomAnimations(Boiler animatable, float partialTicks) {
        super.setCustomAnimations((Object)animatable, partialTicks);
        this.runPassiveAnimations(animatable);
    }

    private void runPassiveAnimations(Boiler boiler) {
        BoilerAnimationDispatcher dispatcher = boiler.getAnimationDispatcher();
        boolean isMovingOnGround = (Boolean)boiler.isMovingHorizontally.get() != false && boiler.onGround();
        boolean isCrawling = boiler.getCrawlingManager().isCrawling();
        Runnable animFunction = boiler.isUnderWater() ? dispatcher::swim : (isMovingOnGround ? (isCrawling ? dispatcher::crawl : (((Boolean)boiler.hasTarget.get()).booleanValue() ? dispatcher::run : dispatcher::walk)) : (isCrawling ? dispatcher::crawlHold : dispatcher::idle));
        animFunction.run();
    }
}

