/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render.entity.parasite.facehugger;

import com.alien.client.render.entity.parasite.EntityHeadData;
import com.alien.client.render.entity.parasite.EntityHeadOffsetData;
import com.alien.common.gameplay.entity.living.alien.parasite.facehugger.Facehugger;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.UUID;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityRendererPipeline;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class FacehuggerModelRenderer
extends AzEntityModelRenderer<Facehugger> {
    public FacehuggerModelRenderer(AzEntityRendererPipeline<Facehugger> entityRendererPipeline, AzLayerRenderer<UUID, Facehugger> layerRenderer) {
        super(entityRendererPipeline, layerRenderer);
    }

    protected void applyRotations(Facehugger facehugger, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (!facehugger.getAttachmentManager().isAttachedToHost()) {
            super.applyRotations((Entity)facehugger, poseStack, ageInTicks, rotationYaw, partialTick, 1.0f);
            return;
        }
        if (facehugger.isDeadOrDying()) {
            super.applyRotations((Entity)facehugger, poseStack, ageInTicks, rotationYaw, partialTick, 1.0f);
            return;
        }
        LivingEntity host = (LivingEntity)facehugger.getVehicle();
        if (host == null) {
            return;
        }
        EntityHeadData data = (EntityHeadData)((Map)EntityHeadData.ENTITY_HEAD_DATA_BY_TYPE.get()).get(host.getType());
        if (data == null) {
            return;
        }
        this.applyHuggingRotations(facehugger, poseStack, partialTick, host, data);
    }

    private void applyHuggingRotations(Facehugger facehugger, PoseStack poseStack, float partialTick, LivingEntity host, EntityHeadData data) {
        float bodyYaw = Mth.rotLerp((float)partialTick, (float)host.yBodyRotO, (float)host.yBodyRot);
        float headYaw = Mth.rotLerp((float)partialTick, (float)host.yHeadRotO, (float)host.yHeadRot) - bodyYaw;
        float headPitch = Mth.rotLerp((float)partialTick, (float)host.getXRot(), (float)host.xRotO);
        double xPivot = data.pivot().x;
        double yPivot = data.pivot().y;
        double zPivot = data.pivot().z;
        double ySize = data.size().y;
        double zSize = data.size().z;
        poseStack.mulPose(Axis.YN.rotationDegrees(bodyYaw));
        poseStack.translate(xPivot, yPivot - (double)host.getBbHeight(), -zPivot);
        poseStack.mulPose(Axis.YN.rotationDegrees(headYaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(headPitch));
        poseStack.translate(-xPivot, -yPivot + (double)host.getBbHeight(), zPivot);
        EntityHeadOffsetData offsetSuppliers = (EntityHeadOffsetData)((Map)EntityHeadOffsetData.ENTITY_HEAD_OFFSET_DATA_BY_TYPE.get()).get(host.getType());
        if (offsetSuppliers != null) {
            Double yOffset = offsetSuppliers.verticalOffsetSupplier().apply(data, (Entity)facehugger);
            Double zOffset = offsetSuppliers.faceOffsetSupplier().apply(data, (Entity)facehugger);
            poseStack.translate(0.0, yOffset.doubleValue(), zOffset.doubleValue());
        } else {
            poseStack.translate(0.0, -ySize, zSize);
        }
    }
}

