/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.data;

import com.avp.AVP;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lib.common.gameplay.gene.GeneBonusData;
import com.lib.common.registry.GeneBonusDataRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class GeneBonusDataReloadListener
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY_NAME = "gene_bonus_data";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public GeneBonusDataReloadListener() {
        super(GSON, DIRECTORY_NAME);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        GeneBonusDataRegistry.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceLocationJsonElementMap.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            GeneBonusData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(err -> AVP.LOGGER.error("Failed to parse GeneBonusData {}: {}", (Object)resourceLocation, err)).ifPresent(GeneBonusDataRegistry::register);
        }
    }
}

