/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.ai;

import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.util.AlienPredicates;
import com.avp.common.registry.init.AVPSoundEvents;
import com.lib.common.data.Cooldown;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class InvestigateVibrationGoal
extends Goal {
    private static final int PISSED_METER_MAX = 100;
    private static final int PISSED_METER_MIN = 0;
    private final Cooldown hissCooldownInTicks = Cooldown.withCooldownTime("hissCooldownInTicks", Duration.ofSeconds(3L));
    private final Xenomorph xenomorph;
    private Path path;
    private int pissedMeter;

    public InvestigateVibrationGoal(Xenomorph xenomorph) {
        this.xenomorph = xenomorph;
        this.path = null;
        this.pissedMeter = 0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        Entity entity;
        if (this.xenomorph.getTarget() != null) {
            return false;
        }
        VibrationInfo lastVibration = this.xenomorph.getVibrationSystemManager().getVibrationData().getCurrentVibration();
        if (lastVibration == null || !((entity = lastVibration.entity()) instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!AlienPredicates.canTarget(this.xenomorph, livingEntity)) {
            return false;
        }
        Vec3 pos = lastVibration.pos();
        this.path = this.xenomorph.getNavigation().createPath(pos.x, pos.y, pos.z, 0);
        return this.path != null;
    }

    public boolean canContinueToUse() {
        return this.path != null && this.xenomorph.getTarget() == null;
    }

    public void start() {
        if (this.path != null) {
            this.xenomorph.getNavigation().moveTo(this.path, 0.5);
            this.getPissed();
        }
    }

    public void tick() {
        VibrationInfo lastVibration = this.xenomorph.getVibrationSystemManager().getVibrationData().getCurrentVibration();
        if (lastVibration != null && !Objects.equals(this.path.getTarget(), BlockPos.containing((Position)lastVibration.pos()))) {
            Entity entity;
            Vec3 pos = lastVibration.pos();
            this.path = this.xenomorph.getNavigation().createPath(pos.x, pos.y, pos.z, 0);
            if (this.path != null) {
                this.xenomorph.getNavigation().moveTo(this.path, 0.5);
                this.getPissed();
            }
            if (this.pissedMeter >= 100 && (entity = lastVibration.entity()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.xenomorph.setTarget(livingEntity);
                this.pissedMeter = 0;
                this.xenomorph.level().playSound(null, this.xenomorph.getX(), this.xenomorph.getY(), this.xenomorph.getZ(), AVPSoundEvents.ENTITY_XENOMORPH_LUNGE.get(), this.xenomorph.getSoundSource(), 1.0f, (this.xenomorph.getRandom().nextFloat() - this.xenomorph.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (this.xenomorph.getNavigation().isDone()) {
            this.path = null;
        }
        this.hissCooldownInTicks.tick();
        this.pissedMeter = Math.clamp((long)(this.pissedMeter - 1), 0, 100);
    }

    public void stop() {
        super.stop();
        this.path = null;
        this.pissedMeter = 0;
    }

    public boolean isInterruptable() {
        return false;
    }

    private void getPissed() {
        this.pissedMeter += Math.clamp(34L, 0, 100);
        if (!this.hissCooldownInTicks.isActive()) {
            this.xenomorph.level().playSound(null, this.xenomorph.getX(), this.xenomorph.getY(), this.xenomorph.getZ(), AVPSoundEvents.ENTITY_XENOMORPH_HISS.get(), this.xenomorph.getSoundSource(), 1.0f, (this.xenomorph.getRandom().nextFloat() - this.xenomorph.getRandom().nextFloat()) * 0.2f + 1.0f);
            this.hissCooldownInTicks.reset();
        }
    }
}

