/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node;

import com.alien.common.gameplay.block.entity.resin.node.ChargeCursor;
import com.lib.common.gameplay.NBTSerializable;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResinSpreader
implements NBTSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResinSpreader.class);
    private static final String CURSORS_KEY = "cursors";
    private static final int CURSOR_LIMIT = 32;
    private static final int MAX_CHARGE = 1000;
    private final int chargeDecayRate;
    private List<ChargeCursor> cursors = new ArrayList<ChargeCursor>();

    public static ResinSpreader create() {
        return new ResinSpreader();
    }

    private ResinSpreader() {
        this.chargeDecayRate = 10;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public void addCursors(BlockPos blockPos, int totalCharge) {
        while (totalCharge > 0) {
            int chargeForCursor = Math.min(totalCharge, 1000);
            this.addCursor(new ChargeCursor(blockPos, chargeForCursor));
            totalCharge -= chargeForCursor;
        }
    }

    private void addCursor(ChargeCursor chargeCursor) {
        if (this.cursors.size() < 32) {
            this.cursors.add(chargeCursor);
        }
    }

    public void updateCursors(LevelAccessor levelAccessor, BlockPos nodePos, RandomSource randomSource) {
        if (this.cursors.isEmpty()) {
            return;
        }
        ArrayList<ChargeCursor> retainedCursors = new ArrayList<ChargeCursor>();
        HashMap<BlockPos, ChargeCursor> cursorsByPos = new HashMap<BlockPos, ChargeCursor>();
        for (ChargeCursor cursor : this.cursors) {
            cursor.update(levelAccessor, nodePos, randomSource, this);
            if (cursor.charge <= 0) continue;
            BlockPos cursorPos = cursor.getPos();
            ChargeCursor cachedCursor = (ChargeCursor)cursorsByPos.get(cursorPos);
            if (cachedCursor == null) {
                cursorsByPos.put(cursorPos, cursor);
                retainedCursors.add(cursor);
                continue;
            }
            if (cursor.charge + cachedCursor.charge <= 1000) {
                cachedCursor.mergeWith(cursor);
                continue;
            }
            retainedCursors.add(cursor);
            if (cursor.charge >= cachedCursor.charge) continue;
            cursorsByPos.put(cursorPos, cursor);
        }
        this.cursors = retainedCursors;
    }

    @Override
    public void load(CompoundTag compoundTag) {
        if (compoundTag.contains(CURSORS_KEY, 9)) {
            this.cursors.clear();
            List list = ChargeCursor.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.getList(CURSORS_KEY, 10))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(ArrayList::new);
            int cursorCount = Math.min(list.size(), 32);
            for (int i = 0; i < cursorCount; ++i) {
                this.addCursor((ChargeCursor)list.get(i));
            }
        }
    }

    @Override
    public void save(CompoundTag compoundTag) {
        ChargeCursor.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.cursors).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put(CURSORS_KEY, tag));
    }
}

