/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node.behavior;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.entity.resin.node.ChargeCursor;
import com.alien.common.gameplay.block.entity.resin.node.ResinSpreader;
import com.alien.common.gameplay.block.resin.vein.ResinVeinBlock;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface VeinSpreadBehavior {
    public int attemptUseCharge(ChargeCursor var1, LevelAccessor var2, BlockPos var3, RandomSource var4, ResinSpreader var5);

    default public byte getResinSpreadDelayInTicks() {
        return 1;
    }

    default public boolean attemptSpreadVein(BlockPos nodePos, LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, @Nullable Collection<Direction> facings) {
        Block block = levelAccessor.getBlockState(nodePos).getBlock();
        return AlienVariantTypes.getFor(block).isSomeAnd(alienVariantType -> {
            ResinVeinBlock resinVeinBlock = alienVariantType.resinVein().get();
            long numberOfDirectionsSpreadTowards = resinVeinBlock.getSpreader().spreadAll(blockState, levelAccessor, blockPos, false);
            return numberOfDirectionsSpreadTowards > 0L;
        });
    }

    default public boolean canChangeBlockStateOnSpread() {
        return true;
    }

    default public int updateDecayDelay(int decayDelay) {
        return 1;
    }
}

