/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.resin.vein;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.entity.resin.node.ChargeCursor;
import com.alien.common.gameplay.block.entity.resin.node.ResinSpreader;
import com.alien.common.gameplay.block.entity.resin.node.behavior.VeinSpreadBehavior;
import com.alien.common.gameplay.block.resin.vein.ResinVeinSpreaderConfig;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.init.AVPSoundEvents;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class ResinVeinBlock
extends MultifaceBlock
implements VeinSpreadBehavior {
    public static final MapCodec<MultifaceBlock> CODEC = ResinVeinBlock.simpleCodec(ResinVeinBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new ResinVeinSpreaderConfig(this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new ResinVeinSpreaderConfig(this, MultifaceSpreader.SpreadType.SAME_POSITION));

    public ResinVeinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @NotNull
    protected MapCodec<MultifaceBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    protected BlockState updateShape(BlockState blockState, @NotNull Direction direction, @NotNull BlockState blockState2, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos blockPos, @NotNull BlockPos blockPos2) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    protected boolean canBeReplaced(@NotNull BlockState blockState, @NotNull BlockPlaceContext blockPlaceContext) {
        AlienVariantType alienVariantType = AlienVariantTypes.getForOrNull(blockState);
        boolean itemInHandIsNotResinVein = alienVariantType != null && !blockPlaceContext.getItemInHand().is(alienVariantType.resinVein().get().asItem());
        return itemInHandIsNotResinVein || super.canBeReplaced(blockState, blockPlaceContext);
    }

    @NotNull
    public MultifaceSpreader getSpreader() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    @NotNull
    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    @Override
    public int attemptUseCharge(ChargeCursor chargeCursor, LevelAccessor levelAccessor, BlockPos nodePos, RandomSource randomSource, ResinSpreader resinSpreader) {
        if (this.attemptPlaceResin(levelAccessor, nodePos, chargeCursor.getPos(), randomSource)) {
            return chargeCursor.getCharge() - 1;
        }
        return randomSource.nextInt(resinSpreader.chargeDecayRate()) == 0 ? Mth.floor((float)((float)chargeCursor.getCharge() * 0.5f)) : chargeCursor.getCharge();
    }

    private boolean attemptPlaceResin(LevelAccessor levelAccessor, BlockPos nodePos, BlockPos cursorPos, RandomSource randomSource) {
        BlockState nodeBlockState = levelAccessor.getBlockState(nodePos);
        BlockState cursorBlockState = levelAccessor.getBlockState(cursorPos);
        AlienVariantType alienVariantType = AlienVariantTypes.getForOrNull(nodeBlockState);
        if (alienVariantType == null) {
            return false;
        }
        BlockState resinBlockState = alienVariantType.resin().get().defaultBlockState();
        for (Direction direction : Direction.allShuffled((RandomSource)randomSource)) {
            BlockPos blockPos2;
            BlockState blockState2;
            if (!ResinVeinBlock.hasFace((BlockState)cursorBlockState, (Direction)direction) || !(blockState2 = levelAccessor.getBlockState(blockPos2 = cursorPos.relative(direction))).is(alienVariantType.resinReplaceableTag())) continue;
            levelAccessor.setBlock(blockPos2, resinBlockState, 3);
            Block.pushEntitiesUp((BlockState)blockState2, (BlockState)resinBlockState, (LevelAccessor)levelAccessor, (BlockPos)blockPos2);
            levelAccessor.playSound(null, blockPos2, AVPSoundEvents.BLOCK_RESIN_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.spreadAll(resinBlockState, levelAccessor, blockPos2, false);
            return true;
        }
        return false;
    }
}

