/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.resin.vein;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.resin.vein.ResinVeinBlock;
import com.alien.common.model.alien.variant.AlienVariantType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

class ResinVeinSpreaderConfig
extends MultifaceSpreader.DefaultSpreaderConfig {
    private final MultifaceSpreader.SpreadType[] spreadTypes;

    public ResinVeinSpreaderConfig(ResinVeinBlock resinVeinBlock, MultifaceSpreader.SpreadType ... spreadTypes) {
        super((MultifaceBlock)resinVeinBlock);
        this.spreadTypes = spreadTypes;
    }

    public boolean stateCanBeReplaced(@NotNull BlockGetter blockGetter, @NotNull BlockPos sourcePos, @NotNull BlockPos destinationPos, @NotNull Direction direction, @NotNull BlockState destinationBlockState) {
        BlockPos blockPos3;
        boolean canDestinationBlockStateBeReplaced;
        AlienVariantType alienVariantType = AlienVariantTypes.getForOrNull((Block)this.block);
        if (alienVariantType == null) {
            return false;
        }
        boolean bl = canDestinationBlockStateBeReplaced = destinationBlockState.is(alienVariantType.resinReplaceableTag()) || destinationBlockState.isAir() || destinationBlockState.is((Block)alienVariantType.resinVein().get());
        if (!canDestinationBlockStateBeReplaced) {
            return false;
        }
        if (sourcePos.distManhattan((Vec3i)destinationPos) == 2 && blockGetter.getBlockState(blockPos3 = sourcePos.relative(direction.getOpposite())).isFaceSturdy(blockGetter, blockPos3, direction)) {
            return false;
        }
        FluidState fluidState = destinationBlockState.getFluidState();
        if (!fluidState.isEmpty() && !fluidState.is((Fluid)Fluids.WATER) || destinationBlockState.is(BlockTags.FIRE)) {
            return false;
        }
        return destinationBlockState.canBeReplaced() || super.stateCanBeReplaced(blockGetter, sourcePos, destinationPos, direction, destinationBlockState);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    MultifaceSpreader.SpreadType @NotNull [] getSpreadTypes() {
        return this.spreadTypes;
    }

    public boolean isOtherBlockValidAsSource(@NotNull BlockState blockState) {
        AlienVariantType alienVariantType = AlienVariantTypes.getForOrNull(blockState);
        return alienVariantType == null || !blockState.is((Block)alienVariantType.resinVein().get());
    }
}

