/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.resin.web;

import com.avp.common.registry.tag.AVPEntityTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ResinWebBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)0.8, (double)0.0, (double)0.8, (double)15.2, (double)16.0, (double)15.2);
    private static final Vec3 MOVEMENT_MODIFIER = new Vec3(0.05, (double)0.05f, 0.05);
    private static final Vec3 STUCK_MOVEMENT_MODIFIER = new Vec3(0.05, 0.0, 0.05);

    public ResinWebBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    protected void entityInside(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, Entity entity) {
        if (!entity.getType().is(AVPEntityTypeTags.ALIENS)) {
            Vec3 eyePos = entity.getEyePosition();
            BlockPos eyeBlockPos = BlockPos.containing((Position)eyePos);
            BlockState eyeBlockState = level.getBlockState(eyeBlockPos);
            Vec3 modifier = eyeBlockState.getBlock() instanceof ResinWebBlock ? STUCK_MOVEMENT_MODIFIER : MOVEMENT_MODIFIER;
            entity.makeStuckInBlock(blockState, modifier);
        }
    }
}

