/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.parasite.facehugger;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.parasite.Parasite;
import com.alien.common.gameplay.entity.living.alien.parasite.facehugger.FacehuggerAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.combat.LungeAtTargetGoal;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Facehugger
extends Parasite {
    private final FacehuggerAnimationDispatcher animationDispatcher = new FacehuggerAnimationDispatcher(this);

    public static AttributeSupplier.Builder createFacehuggerAttributes() {
        return Facehugger.applyFrom(AVP.config.statsConfigs.FACEHUGGER_STATS, Monster.createMonsterAttributes());
    }

    public Facehugger(EntityType<? extends Facehugger> entityType, Level level) {
        super((EntityType<? extends Parasite>)entityType, level);
        this.config = AVP.config.statsConfigs.FACEHUGGER_STATS;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Facehugger.getType(alienVariant, this.isRoyal());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new LungeAtTargetGoal((Mob)this, 0.75f, 60, 1.0, 12.0).setOnLungeCallback(this::runLungeAnimation));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, x$0 -> this.isValidHost((LivingEntity)x$0)));
    }

    private void runLungeAnimation() {
        this.animationDispatcher.lunge();
    }

    @Override
    protected void doPush(@NotNull Entity entity) {
        if (!entity.getType().is(AVPEntityTypeTags.ALIENS)) {
            super.doPush(entity);
        }
    }

    protected void playStepSound(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.015f, 2.0f);
    }

    @Override
    public boolean isPersistenceRequired() {
        return super.isPersistenceRequired() || this.attachmentManager.isAttachedToHost();
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return 0.0f;
    }

    public FacehuggerAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    @Nullable
    public static EntityType<? extends Alien> getType(AlienVariant alienVariant, boolean isRoyal) {
        if (isRoyal) {
            return switch (alienVariant) {
                default -> throw new MatchException(null, null);
                case AlienVariant.NORMAL -> AlienEntityTypes.ROYAL_FACEHUGGER.get();
                case AlienVariant.NETHER -> AlienEntityTypes.ROYAL_NETHER_FACEHUGGER.get();
                case AlienVariant.ABERRANT -> AlienEntityTypes.ROYAL_ABERRANT_FACEHUGGER.get();
                case AlienVariant.IRRADIATED -> null;
            };
        }
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.FACEHUGGER.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_FACEHUGGER.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_FACEHUGGER.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

