/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.queen;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.gameplay.level.saveddata.QueenSpawnChunkData;
import com.alien.common.gameplay.level.saveddata.StrainLeakData;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.server.ServerLevelManager;
import com.avp.server.ServerLevelManagerAccessor;
import com.just.core.functional.option.Option;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class QueenSpawning {
    private static final int MAX_OVERWORLD_Y_LEVEL = -24;
    public static final SpawnPlacements.SpawnPredicate<Queen> PREDICATE = (entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource) -> {
        ServerLevel serverLevel = serverLevelAccessor.getLevel();
        ServerLevelManager serverLevelManager = ((ServerLevelManagerAccessor)serverLevel).avp$getServerLevelManager();
        if (serverLevelManager.getQueenSpawnCooldown().isActive()) {
            return false;
        }
        Option<QueenSpawnChunkData> queenSpawnChunkDataOption = QueenSpawnChunkData.getOrCreate((Level)serverLevel);
        boolean isChunkSpawnAvailable = queenSpawnChunkDataOption.isSomeAnd(queenSpawnChunkData -> !queenSpawnChunkData.isChunkBlacklisted(blockPos));
        if (!isChunkSpawnAvailable) {
            return false;
        }
        int maxYLevelForDimension = serverLevel.dimension() == Level.NETHER ? serverLevel.dimensionType().logicalHeight() : -24;
        return blockPos.getY() <= maxYLevelForDimension && QueenSpawning.canStrainSpawnInLevel(serverLevel, (EntityType<Queen>)entityType) && QueenSpawning.checkSpawnRules((EntityType<? extends Monster>)entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource);
    };

    private static boolean canStrainSpawnInLevel(ServerLevel serverLevel, EntityType<Queen> entityType) {
        Option<StrainLeakData> strainLeakDataOption = StrainLeakData.getOrCreate((Level)serverLevel);
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(entityType);
        return alienVariantTypeOption.isSomeAnd(alienVariantType -> strainLeakDataOption.isSomeAnd(strainLeakData -> strainLeakData.hasVariant(alienVariantType.variant())));
    }

    public static boolean checkSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(entityType);
        return Monster.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && (Boolean)HiveLevelData.getOrCreate((Level)serverLevelAccessor.getLevel()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(blockPos, hive -> alienVariantTypeOption.isSomeAnd(alienVariantType -> Objects.equals((Object)hive.getVariant(), (Object)alienVariantType.variant())))).match(nearestHive -> !nearestHive.getSpaceManager().isBlockPosWithinHiveBuffer(blockPos), () -> true) != false;
    }
}

