/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive;

import com.alien.common.data.AlienAdvancements;
import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.util.AlienPredicates;
import com.avp.AVP;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class HiveBossBarManager {
    public static final Map<AlienVariant, String> ALIEN_VARIANT_TO_TRANSLATABLE_STRING_MAP = Arrays.stream(AlienVariant.values()).collect(Collectors.toMap(Function.identity(), alienVariant -> "bossbar.avp.hive." + alienVariant.name().toLowerCase(Locale.US) + ".title"));
    private static final Map<AlienVariant, Component> ALIEN_VARIANT_TO_COMPONENT_NAME_MAP = ALIEN_VARIANT_TO_TRANSLATABLE_STRING_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Component.translatable((String)((String)entry.getValue()))));
    private static final Predicate<EntityType<?>> XENOMORPH_PREDICATE = entityType -> entityType.is(AVPEntityTypeTags.XENOMORPHS);
    private final Hive hive;
    private final ServerBossEvent bossEvent;
    private int maximumSeenXenomorphCount;

    public HiveBossBarManager(Hive hive) {
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(ALIEN_VARIANT_TO_COMPONENT_NAME_MAP.get((Object)hive.getVariant()), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(AVP.config.hiveConfigs.HIVE_DARKEN_SCREEN);
        this.hive = hive;
    }

    public void tick() {
        this.updateBossBarProgress();
        this.updateBossBarColor();
        this.updateBossBarTitle();
        this.updateTrackingPlayers();
    }

    private void updateBossBarProgress() {
        int loadedXenomorphCount = this.hive.getMembershipManager().getMembersMatching(XENOMORPH_PREDICATE).size();
        int currentReserveXenomorphCount = this.hive.getReserveManager().getCountMatching(XENOMORPH_PREDICATE);
        int totalXenomorphCount = loadedXenomorphCount + currentReserveXenomorphCount;
        this.maximumSeenXenomorphCount = Math.max(this.maximumSeenXenomorphCount, totalXenomorphCount);
        this.bossEvent.setProgress((float)totalXenomorphCount / (float)this.maximumSeenXenomorphCount);
    }

    private void updateBossBarColor() {
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.hive.getVariant());
        this.bossEvent.setColor(alienVariantType.bossBarColor());
    }

    private void updateBossBarTitle() {
        AlienVariant variant = this.hive.getVariant();
        Component component = ALIEN_VARIANT_TO_COMPONENT_NAME_MAP.get((Object)variant);
        this.bossEvent.setName(component);
    }

    private void updateTrackingPlayers() {
        if (this.hive.ageInTicks() % 20 == 0) {
            this.removeNonTargetPlayers(this.bossEvent);
        }
        if (!this.hive.isAlive()) {
            this.bossEvent.removeAllPlayers();
        }
    }

    private void removeNonTargetPlayers(ServerBossEvent bossEvent) {
        List<ServerPlayer> playersToRemove = bossEvent.getPlayers().stream().filter(player -> {
            if (!AlienPredicates.isValidTarget(this.hive.getVariant(), (LivingEntity)player)) {
                return true;
            }
            return !this.hive.getSpaceManager().isEntityWithinHive((Entity)player) || !this.isPlayerInSameDimensionAsHive((ServerPlayer)player);
        }).toList();
        playersToRemove.forEach(arg_0 -> ((ServerBossEvent)bossEvent).removePlayer(arg_0));
    }

    private boolean isPlayerInSameDimensionAsHive(ServerPlayer player) {
        return Objects.equals(player.level().dimensionType(), this.hive.level().dimensionType());
    }

    public void onHiveRemoved() {
        Level level = this.hive.level();
        if (level.getDifficulty() != Difficulty.PEACEFUL && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.players().stream().filter(player -> this.hive.getSpaceManager().isEntityWithinHive((Entity)player)).forEach(AlienAdvancements.KILL_A_HIVE::grant);
        }
        this.bossEvent.removeAllPlayers();
    }

    public void trackPlayer(ServerPlayer player) {
        this.bossEvent.addPlayer(player);
    }

    public boolean isTrackingPlayers() {
        return !this.bossEvent.getPlayers().isEmpty();
    }
}

