/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.ai.task.impl.balance;

import com.alien.common.gameplay.entity.living.alien.GrowthManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.ai.task.HiveTask;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.world.entity.Entity;

public abstract class BalanceHiveTask
extends HiveTask {
    private static final int FREQUENCY = 6000;

    protected BalanceHiveTask(Hive hive) {
        super(hive);
    }

    @Override
    public boolean canRun() {
        return this.hive.ageInTicks() % 6000 == 0;
    }

    protected void growXenomorph(Xenomorph xenomorph) {
        GrowthManager.GrowthResult growthResult;
        GrowthManager.GrowthResult growthResult2 = growthResult = xenomorph.getGrowthManager().grow();
        Objects.requireNonNull(growthResult2);
        GrowthManager.GrowthResult growthResult3 = growthResult2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GrowthManager.GrowthResult.AlreadyFullyGrown.class, GrowthManager.GrowthResult.CanNotGrow.class, GrowthManager.GrowthResult.Success.class, GrowthManager.GrowthResult.FailedTransitionResult.class}, (Object)growthResult3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GrowthManager.GrowthResult.AlreadyFullyGrown $ = (GrowthManager.GrowthResult.AlreadyFullyGrown)growthResult3;
                break;
            }
            case 1: {
                GrowthManager.GrowthResult.CanNotGrow $ = (GrowthManager.GrowthResult.CanNotGrow)growthResult3;
                break;
            }
            case 2: {
                GrowthManager.GrowthResult.Success success = (GrowthManager.GrowthResult.Success)growthResult3;
                this.handleXenomorphGrowth(xenomorph, success.newEntity());
                break;
            }
            case 3: {
                GrowthManager.GrowthResult.FailedTransitionResult failedTransitionResult = (GrowthManager.GrowthResult.FailedTransitionResult)growthResult3;
            }
        }
    }

    private void handleXenomorphGrowth(Xenomorph xenomorph, Entity grownEntity) {
        boolean isLeader = Objects.equals(xenomorph.getUUID(), this.hive.getLeadershipManager().getLeaderIdOrNull());
        this.hive.getMembershipManager().removeMember((Entity)xenomorph);
        this.hive.getMembershipManager().addMember(grownEntity);
        if (isLeader) {
            this.hive.getLeadershipManager().setLeaderId(grownEntity.getUUID());
        }
    }
}

