/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.membership;

import com.alien.common.model.hive.HiveMemberData;
import com.avp.AVP;
import com.just.core.cache.Cache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class HiveMembershipCache
extends Cache<UUID, HiveMemberData> {
    private final Map<EntityType<?>, List<Map.Entry<UUID, HiveMemberData>>> hiveMemberDataByEntityTypeMap = new HashMap();

    public Map<EntityType<?>, List<Map.Entry<UUID, HiveMemberData>>> getMembersByEntityTypeMap() {
        return Collections.unmodifiableMap(this.hiveMemberDataByEntityTypeMap);
    }

    public List<Map.Entry<UUID, HiveMemberData>> getMembersByEntityType(EntityType<?> entityType) {
        return this.hiveMemberDataByEntityTypeMap.getOrDefault(entityType, List.of());
    }

    protected void onAddToCache(UUID uuid, @Nullable HiveMemberData oldValue, HiveMemberData newValue) {
        EntityType entityType = (EntityType)newValue.getEntityType().unwrapOr(null);
        if (entityType == null) {
            AVP.LOGGER.warn("onAddToCache - Invalid entity type. Resource Location: {}", (Object)newValue.entityTypeResourceLocation());
            return;
        }
        List list = this.hiveMemberDataByEntityTypeMap.computeIfAbsent(entityType, $ -> new ArrayList());
        if (oldValue != null) {
            Map.Entry<UUID, HiveMemberData> oldEntry = Map.entry(uuid, oldValue);
            list.remove(oldEntry);
        }
        Map.Entry<UUID, HiveMemberData> newEntry = Map.entry(uuid, newValue);
        list.add(newEntry);
    }

    protected void onRemoveFromCache(UUID uuid, HiveMemberData value) {
        EntityType entityType = (EntityType)value.getEntityType().unwrapOr(null);
        if (entityType == null) {
            AVP.LOGGER.warn("onRemoveFromCache - Invalid entity type. Resource Location: {}", (Object)value.entityTypeResourceLocation());
            return;
        }
        Map.Entry<UUID, HiveMemberData> entry = Map.entry(uuid, value);
        this.hiveMemberDataByEntityTypeMap.computeIfAbsent(entityType, $ -> new ArrayList()).remove(entry);
    }

    protected void onClearCache() {
        super.onClearCache();
        this.hiveMemberDataByEntityTypeMap.clear();
    }
}

