/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.vent;

import com.just.core.cache.Cache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import org.jetbrains.annotations.Nullable;

public class HiveVentCache
extends Cache<BlockPos, Void> {
    private final Map<SectionPos, Set<BlockPos>> ventPositionsBySectionPos = new HashMap<SectionPos, Set<BlockPos>>();

    protected void onAddToCache(BlockPos id, @Nullable Void oldValue, Void newValue) {
        SectionPos sectionPos = SectionPos.of((BlockPos)id);
        this.ventPositionsBySectionPos.computeIfAbsent(sectionPos, $ -> new HashSet()).add(id);
        super.onAddToCache((Object)id, (Object)oldValue, (Object)newValue);
    }

    protected void onRemoveFromCache(BlockPos id, Void value) {
        SectionPos sectionPos = SectionPos.of((BlockPos)id);
        this.ventPositionsBySectionPos.compute(sectionPos, ($1, ventPositions) -> {
            if (ventPositions == null) {
                return null;
            }
            ventPositions.remove(id);
            if (ventPositions.isEmpty()) {
                return null;
            }
            return ventPositions;
        });
        super.onRemoveFromCache((Object)id, (Object)value);
    }

    public Set<BlockPos> getVentsForSection(BlockPos blockPos) {
        return this.getVentsForSection(SectionPos.of((BlockPos)blockPos));
    }

    public Set<BlockPos> getVentsForSection(SectionPos sectionPos) {
        return this.ventPositionsBySectionPos.getOrDefault(sectionPos, Set.of());
    }
}

