/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.gameevent.listener;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.entity.resin.vent.ResinVentBlockEntity;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.membership.HiveReserveManager;
import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.lib.common.gameplay.util.spatial.block.BlockPosUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CryForHelpListener
implements GameEventListener {
    private static final int MAXIMUM_SUMMONED_XENOMORPHS_PER_HIVE = 60;
    private final PositionSource positionSource;

    public CryForHelpListener(PositionSource positionSource) {
        this.positionSource = positionSource;
    }

    @NotNull
    public PositionSource getListenerSource() {
        return this.positionSource;
    }

    @NotNull
    public GameEventListener.DeliveryMode getDeliveryMode() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }

    public int getListenerRadius() {
        return 16;
    }

    public boolean handleGameEvent(@NotNull ServerLevel serverLevel, @NotNull Holder<GameEvent> holder, @NotNull GameEvent.Context context, @NotNull Vec3 vec3) {
        EntityType randomSummonType;
        BlockPos spawnPos;
        ResinVentBlockEntity resinVentBlockEntity;
        Entity sourceEntity = context.sourceEntity();
        if (sourceEntity == null || AlienVariantTypes.getFor(sourceEntity).isNoneOr(alienVariantType -> !holder.is(alienVariantType.cryForHelpEvent().getHolder()))) {
            return false;
        }
        BlockPos blockPos = this.positionSource.getPosition((Level)serverLevel).map(BlockPos::containing).orElse(null);
        if (blockPos == null) {
            return false;
        }
        BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ResinVentBlockEntity) || (resinVentBlockEntity = (ResinVentBlockEntity)blockEntity).getAlienSpawnCooldown().isActive()) {
            return false;
        }
        Hive hive = resinVentBlockEntity.getHive();
        if (hive == null || hive.getMembershipManager().getLoadedMembers().size() >= 60) {
            return false;
        }
        BlockPos basePos = resinVentBlockEntity.getBlockPos();
        List<BlockPos> freeSpaces = BlockPosUtil.getNeighborsMatching((Level)serverLevel, basePos, blockState -> blockState.is(AVPBlockTags.RESIN_WEBS));
        BlockPos blockPos2 = spawnPos = freeSpaces.isEmpty() ? null : freeSpaces.get(sourceEntity.getRandom().nextInt(freeSpaces.size()));
        if (spawnPos == null) {
            return false;
        }
        HiveReserveManager reserveManager = hive.getReserveManager();
        List<EntityType> availableEntityTypes = reserveManager.getAvailableEntityTypes().stream().filter(entityType -> entityType.is(AVPEntityTypeTags.ANSWERS_XENOMORPH_CRIES_FOR_HELP)).toList();
        EntityType entityType2 = randomSummonType = availableEntityTypes.isEmpty() ? null : availableEntityTypes.get(sourceEntity.getRandom().nextInt(availableEntityTypes.size()));
        if (randomSummonType == null || !reserveManager.canSpawn(randomSummonType)) {
            return false;
        }
        Entity summonedAlien = randomSummonType.spawn(serverLevel, spawnPos, MobSpawnType.MOB_SUMMONED);
        if (summonedAlien != null) {
            resinVentBlockEntity.getAlienSpawnCooldown().reset();
            reserveManager.add(randomSummonType, -1);
            if (sourceEntity instanceof Mob) {
                Mob sourceMob = (Mob)sourceEntity;
                if (summonedAlien instanceof Mob) {
                    Mob summonedAlienMob = (Mob)summonedAlien;
                    summonedAlienMob.setTarget(sourceMob.getTarget());
                }
            }
            return true;
        }
        return false;
    }
}

