/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.gameevent.listener;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.entity.resin.node.ResinSpreader;
import com.alien.common.model.resin.ResinData;
import com.alien.common.model.resin.ResinProducer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ResinSpreadListener
implements GameEventListener {
    final ResinSpreader resinSpreader;
    private final PositionSource positionSource;
    private final SpreaderType spreaderType;

    public ResinSpreadListener(PositionSource positionSource, SpreaderType spreaderType) {
        this.positionSource = positionSource;
        this.spreaderType = spreaderType;
        this.resinSpreader = ResinSpreader.create();
    }

    @NotNull
    public PositionSource getListenerSource() {
        return this.positionSource;
    }

    @NotNull
    public GameEventListener.DeliveryMode getDeliveryMode() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }

    public int getListenerRadius() {
        return 8;
    }

    public ResinSpreader getResinSpreader() {
        return this.resinSpreader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleGameEvent(@NotNull ServerLevel serverLevel, @NotNull Holder<GameEvent> holder, @NotNull GameEvent.Context context, @NotNull Vec3 vec3) {
        BlockPos blockPos;
        Entity sourceEntity = context.sourceEntity();
        if (sourceEntity == null) {
            return false;
        }
        SpreaderType spreaderType = this.spreaderType;
        if (!(spreaderType instanceof SpreaderType.Block)) return false;
        SpreaderType.Block block = (SpreaderType.Block)spreaderType;
        try {
            BlockPos blockPos2;
            blockPos = blockPos2 = block.blockPos();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (AlienVariantTypes.getFor(serverLevel.getBlockState(blockPos)).isNoneOr(alienVariantType -> !holder.is(alienVariantType.resinSpreadEvent().getHolder()))) {
            return false;
        }
        spreaderType = context.sourceEntity();
        if (!(spreaderType instanceof ResinProducer)) return false;
        ResinProducer resinProducer = (ResinProducer)((Object)spreaderType);
        ResinData resinData = resinProducer.getResinManager().resinData();
        if (resinData == null) {
            return false;
        }
        int resin = resinData.resin();
        this.resinSpreader.addCursors(BlockPos.containing((Position)vec3.relative(Direction.UP, 0.5)), resin);
        resinData.setResin(0);
        return true;
    }

    public static sealed interface SpreaderType {

        public record Block(BlockPos blockPos) implements SpreaderType
        {
        }

        public record Entity(net.minecraft.world.entity.Entity entity) implements SpreaderType
        {
        }
    }
}

