/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.saveddata;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.avp.AVP;
import com.avp.common.util.AVPPredicates;
import com.just.core.functional.option.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class HiveLevelData
extends SavedData {
    private static final String DATA_NAME = "hive_data";
    private static final String HIVES_KEY = "hives";
    private final Level level;
    private final Map<UUID, Hive> hiveByIdMap;

    private HiveLevelData(Level level) {
        this(level, new HashMap<UUID, Hive>());
    }

    private HiveLevelData(Level level, Map<UUID, Hive> hiveByIdMap) {
        this.hiveByIdMap = hiveByIdMap;
        this.level = level;
    }

    public void tick() {
        this.hiveByIdMap.values().removeIf(hive -> {
            hive.tick();
            boolean shouldRemove = hive.isRemoved();
            if (shouldRemove) {
                hive.onRemove();
            }
            return shouldRemove;
        });
        this.setDirty();
    }

    public Option<Hive> findNearestHive(BlockPos blockPos) {
        return this.findNearestHive(blockPos, AVPPredicates.alwaysTrue());
    }

    public Option<Hive> findNearestHive(BlockPos blockPos, Predicate<Hive> hivePredicate) {
        double distanceSquared = Double.MAX_VALUE;
        Hive closestHive = null;
        for (Hive hive : this.hiveByIdMap.values()) {
            BlockPos centerPos = hive.centerPosition();
            double relativeDistanceSquared = blockPos.distToCenterSqr((double)centerPos.getX(), (double)centerPos.getY(), (double)centerPos.getZ());
            if (!(relativeDistanceSquared < distanceSquared) || !hivePredicate.test(hive)) continue;
            distanceSquared = relativeDistanceSquared;
            closestHive = hive;
        }
        return Option.ofNullable(closestHive);
    }

    public Hive createHive(Alien alien) {
        Hive hive = this.createHive(alien.blockPosition());
        hive.setVariant(alien.getVariant());
        hive.getMembershipManager().addMember((Entity)alien);
        hive.getLeadershipManager().setLeaderId(alien.getUUID());
        hive.ping((Entity)alien);
        return hive;
    }

    public Hive createHive(BlockPos blockPos) {
        UUID id = UUID.randomUUID();
        Hive hive = new Hive(this.level, id);
        hive.moveCenter(blockPos);
        this.hiveByIdMap.put(id, hive);
        AVP.LOGGER.debug("Created hive: {}", (Object)id);
        return hive;
    }

    public void removeHive(Hive hive) {
        this.hiveByIdMap.remove(hive.id());
    }

    public Collection<Hive> allHives() {
        return this.hiveByIdMap.values();
    }

    public Option<Hive> hive(@NotNull UUID id) {
        return Option.ofNullable((Object)this.hiveByIdMap.get(id));
    }

    public boolean hasHive(Hive hive) {
        return this.hive(hive.id()).isSome();
    }

    public static HiveLevelData load(Level level, CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<UUID, Hive> map = new HashMap<UUID, Hive>();
        CompoundTag hivesTag = compoundTag.getCompound(HIVES_KEY);
        for (String key : hivesTag.getAllKeys()) {
            UUID id = UUID.fromString(key);
            CompoundTag hiveTag = hivesTag.getCompound(key);
            Hive hive = new Hive(level, id);
            hive.load(hiveTag);
            map.put(hive.id(), hive);
        }
        return new HiveLevelData(level, map);
    }

    @NotNull
    public CompoundTag save(CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        CompoundTag hivesTag = new CompoundTag();
        this.hiveByIdMap.forEach((hiveId, hive) -> {
            CompoundTag hiveTag = new CompoundTag();
            hive.save(hiveTag);
            hivesTag.put(hiveId.toString(), (Tag)hiveTag);
        });
        compoundTag.put(HIVES_KEY, (Tag)hivesTag);
        return compoundTag;
    }

    public static Option<HiveLevelData> getOrCreate(Level level) {
        return level.isClientSide ? Option.none() : Option.some((Object)((Object)((HiveLevelData)((ServerLevel)level).getDataStorage().computeIfAbsent(HiveLevelData.factory(level), DATA_NAME))));
    }

    public static SavedData.Factory<HiveLevelData> factory(Level level) {
        return new SavedData.Factory(() -> new HiveLevelData(level), (compoundTag, provider) -> HiveLevelData.load(level, compoundTag, provider), null);
    }
}

