/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.saveddata;

import com.just.core.functional.option.Option;
import com.lib.common.gameplay.util.spatial.region.RegionPos;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class QueenSpawnChunkData
extends SavedData {
    private static final String DATA_NAME = "queen_spawn_chunk_data_v2";
    private static final String NBT_REGIONS = "blacklistedRegions";
    private final Map<RegionPos, BitSet> regionChunkBits = new HashMap<RegionPos, BitSet>();

    private QueenSpawnChunkData() {
    }

    private QueenSpawnChunkData(Map<RegionPos, BitSet> regionChunkBits) {
        this.regionChunkBits.putAll(regionChunkBits);
    }

    public void addChunkToBlacklist(BlockPos pos) {
        this.addChunkToBlacklist(new ChunkPos(pos));
    }

    public void addChunkToBlacklist(ChunkPos pos) {
        RegionPos region = RegionPos.fromChunkPos(pos);
        BitSet bitSet = this.regionChunkBits.computeIfAbsent(region, k -> new BitSet(16384));
        int bitIndex = QueenSpawnChunkData.bitIndexInRegion(pos.x, pos.z);
        bitSet.set(bitIndex);
        this.setDirty();
    }

    public boolean isChunkBlacklisted(BlockPos pos) {
        return this.isChunkBlacklisted(new ChunkPos(pos));
    }

    public boolean isChunkBlacklisted(ChunkPos pos) {
        RegionPos region = RegionPos.fromChunkPos(pos);
        BitSet bitSet = this.regionChunkBits.get(region);
        if (bitSet == null) {
            return false;
        }
        int bitIndex = QueenSpawnChunkData.bitIndexInRegion(pos.x, pos.z);
        return bitSet.get(bitIndex);
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        CompoundTag regionsTag = new CompoundTag();
        for (Map.Entry<RegionPos, BitSet> entry : this.regionChunkBits.entrySet()) {
            RegionPos region = entry.getKey();
            BitSet bits = entry.getValue();
            byte[] bytes = bits.toByteArray();
            long[] longs = QueenSpawnChunkData.toLongArray(bytes);
            regionsTag.put(Long.toString(region.toLong()), (Tag)new LongArrayTag(longs));
        }
        compoundTag.put(NBT_REGIONS, (Tag)regionsTag);
        return compoundTag;
    }

    public static QueenSpawnChunkData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<RegionPos, BitSet> regionMap = new HashMap<RegionPos, BitSet>();
        CompoundTag regionsTag = compoundTag.getCompound(NBT_REGIONS);
        for (String key : regionsTag.getAllKeys()) {
            long packedKey = Long.parseLong(key);
            RegionPos region = RegionPos.fromLong(packedKey);
            long[] longs = regionsTag.getLongArray(key);
            byte[] bytes = QueenSpawnChunkData.toByteArray(longs);
            BitSet bitSet = BitSet.valueOf(bytes);
            regionMap.put(region, bitSet);
        }
        return new QueenSpawnChunkData(regionMap);
    }

    public static Option<QueenSpawnChunkData> getOrCreate(Level level) {
        return level.isClientSide ? Option.none() : Option.some((Object)((Object)((QueenSpawnChunkData)((ServerLevel)level).getDataStorage().computeIfAbsent(QueenSpawnChunkData.factory(level), DATA_NAME))));
    }

    public static SavedData.Factory<QueenSpawnChunkData> factory(Level level) {
        return new SavedData.Factory(QueenSpawnChunkData::new, QueenSpawnChunkData::load, null);
    }

    private static int bitIndexInRegion(int chunkX, int chunkZ) {
        int localX = chunkX & 0x7F;
        int localZ = chunkZ & 0x7F;
        return localZ * 128 + localX;
    }

    private static long[] toLongArray(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int len = (int)Math.ceil((double)bytes.length / 8.0);
        long[] result = new long[len];
        for (int i = 0; i < len && buffer.remaining() >= 8; ++i) {
            result[i] = buffer.getLong();
        }
        if (buffer.remaining() > 0) {
            long last = 0L;
            int i = 0;
            while (buffer.remaining() > 0) {
                last |= ((long)buffer.get() & 0xFFL) << 8 * i;
                ++i;
            }
            result[len - 1] = last;
        }
        return result;
    }

    private static byte[] toByteArray(long[] longs) {
        ByteBuffer buffer = ByteBuffer.allocate(longs.length * 8);
        for (long l : longs) {
            buffer.putLong(l);
        }
        return buffer.array();
    }
}

