/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.level.saveddata;

import com.alien.common.model.alien.variant.AlienVariant;
import com.just.core.functional.option.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class StrainLeakData
extends SavedData {
    private static final String DATA_NAME = "strain_leak_data";
    private static final String NBT_ALIEN_VARIANTS = "alienVariants";
    private final Map<AlienVariant, Integer> variantCounts = new HashMap<AlienVariant, Integer>();

    private StrainLeakData(Level level) {
        if (level.dimension() == Level.OVERWORLD) {
            this.variantCounts.put(AlienVariant.NORMAL, 1000000);
        } else if (level.dimension() == Level.NETHER) {
            this.variantCounts.put(AlienVariant.NETHER, 1000000);
        }
    }

    public boolean hasVariant(AlienVariant variant) {
        return this.variantCounts.getOrDefault((Object)variant, 0) > 0;
    }

    public int getCount(AlienVariant variant) {
        return this.variantCounts.getOrDefault((Object)variant, 0);
    }

    public Set<AlienVariant> getVariants() {
        return this.variantCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    public void add(AlienVariant variant, int amount) {
        if (amount == 0) {
            return;
        }
        this.variantCounts.compute(variant, (key, oldValue) -> {
            int current = oldValue == null ? 0 : oldValue;
            int newCount = current + amount;
            if (newCount <= 0) {
                return null;
            }
            return newCount;
        });
        this.setDirty();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        CompoundTag variantTag = new CompoundTag();
        for (Map.Entry<AlienVariant, Integer> entry : this.variantCounts.entrySet()) {
            int id = entry.getKey().getId();
            Integer count = entry.getValue();
            if (count <= 0) continue;
            variantTag.putInt(Integer.toString(id), count.intValue());
        }
        compoundTag.put(NBT_ALIEN_VARIANTS, (Tag)variantTag);
        return compoundTag;
    }

    public static StrainLeakData load(Level level, CompoundTag compoundTag, HolderLookup.Provider provider) {
        StrainLeakData data = new StrainLeakData(level);
        if (compoundTag.contains(NBT_ALIEN_VARIANTS, 10)) {
            CompoundTag variantTag = compoundTag.getCompound(NBT_ALIEN_VARIANTS);
            for (String key : variantTag.getAllKeys()) {
                try {
                    int id = Integer.parseInt(key);
                    int count = variantTag.getInt(key);
                    AlienVariant.getById(id).ifSome(variant -> {
                        if (count > 0) {
                            data.variantCounts.put((AlienVariant)((Object)variant), count);
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return data;
    }

    public static Option<StrainLeakData> getOrCreate(Level level) {
        return level.isClientSide ? Option.none() : Option.some((Object)((Object)((StrainLeakData)((ServerLevel)level).getDataStorage().computeIfAbsent(StrainLeakData.factory(level), DATA_NAME))));
    }

    public static SavedData.Factory<StrainLeakData> factory(Level level) {
        return new SavedData.Factory(() -> new StrainLeakData(level), (compoundTag, provider) -> StrainLeakData.load(level, compoundTag, provider), null);
    }
}

