/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.model.resin;

import com.alien.common.model.resin.ReadableResinData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class ResinData
implements ReadableResinData {
    public static final Codec<ResinData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("resin").forGetter(ResinData::resin), (App)Codec.INT.fieldOf("resinMax").forGetter(ResinData::resinMax), (App)Codec.INT.fieldOf("resinPerTick").forGetter(ResinData::resinPerTick), (App)Codec.INT.fieldOf("tickRate").forGetter(ResinData::tickRate)).apply((Applicative)instance, ResinData::new));
    private int resin;
    private int resinMax;
    private int resinPerTick;
    private int tickRate;

    public ResinData(int initialResin, int resinMax, int resinPerTick, int tickRate) {
        this.resin = initialResin;
        this.resinMax = resinMax;
        this.resinPerTick = resinPerTick;
        this.tickRate = tickRate;
    }

    public void addResin(int resin) {
        this.setResin(this.resin + resin);
    }

    public void setResin(int resin) {
        this.resin = Math.clamp((long)resin, 0, this.resinMax);
    }

    public void setResinMax(int resinMax) {
        this.resinMax = Math.max(0, resinMax);
    }

    @Override
    public int resin() {
        return this.resin;
    }

    @Override
    public int resinMax() {
        return this.resinMax;
    }

    @Override
    public int resinPerTick() {
        return this.resinPerTick;
    }

    @Override
    public int tickRate() {
        return this.tickRate;
    }
}

