/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.util;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.Host;
import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import com.just.core.functional.option.Option;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AlienPredicates {
    public static boolean canTarget(@NotNull Alien alien, @NotNull LivingEntity potentialTarget) {
        return AlienPredicates.canContinueTargeting(alien, potentialTarget) && (AlienPredicates.isAlienTarget(alien, potentialTarget) || AlienPredicates.isHated(alien, potentialTarget) || AlienPredicates.isStandingOnResin(potentialTarget) || AlienPredicates.doesTargetHaveEnemyVariantEmbryo(alien.getVariant(), potentialTarget));
    }

    public static boolean canContinueTargeting(@NotNull Alien alien, @NotNull LivingEntity potentialTarget) {
        Alien targetedAlien;
        return AlienPredicates.isValidTarget(alien.getVariant(), potentialTarget) && (!(potentialTarget instanceof Alien) || AlienPredicates.areAliensEnemies(alien, targetedAlien = (Alien)potentialTarget));
    }

    public static boolean isAlienTarget(@NotNull Alien alien, @NotNull LivingEntity potentialTarget) {
        Alien potentialAlienTarget;
        return potentialTarget.getType().is(AVPEntityTypeTags.ALIENS) && potentialTarget instanceof Alien && AlienPredicates.areAliensEnemies(alien, potentialAlienTarget = (Alien)potentialTarget);
    }

    public static boolean areAliensEnemies(Alien first, Alien second) {
        return AlienPredicates.areAliensDifferentStrains(first, second);
    }

    private static boolean areAliensDifferentStrains(Alien first, Alien second) {
        return !Objects.equals(first.isAberrant(), second.isAberrant()) || !Objects.equals(first.isIrradiated(), second.isIrradiated()) || !Objects.equals(first.isNetherAfflicted(), second.isNetherAfflicted());
    }

    public static boolean isValidTarget(AlienVariant selfVariant, @NotNull LivingEntity potentialTarget) {
        return !(potentialTarget instanceof Bat || potentialTarget instanceof Creeper || !potentialTarget.isAlive() || !potentialTarget.attackable() || potentialTarget instanceof Player && AVPPredicates.IS_IMMORTAL.test(potentialTarget) || AVPPredicates.hasEmbryo((Entity)potentialTarget) && !AlienPredicates.doesTargetHaveEnemyVariantEmbryo(selfVariant, potentialTarget) || AVPPredicates.isParasiteAttached((Entity)potentialTarget));
    }

    private static boolean doesTargetHaveEnemyVariantEmbryo(AlienVariant selfVariant, @NotNull LivingEntity potentialTarget) {
        Host host;
        return potentialTarget instanceof Host && (host = (Host)potentialTarget).getEmbryoType().isSomeAnd(embryoType -> AlienVariantTypes.getFor(embryoType).isSomeAnd(alienVariantType -> !Objects.equals((Object)selfVariant, (Object)alienVariantType.variant())));
    }

    public static boolean isTargetingHiveMember(@NotNull Alien alien, @NotNull LivingEntity potentialTarget) {
        Alien targetedAlien;
        LivingEntity livingEntity;
        Mob mob;
        return potentialTarget instanceof Mob && (mob = (Mob)potentialTarget).getTarget() != null && (livingEntity = mob.getTarget()) instanceof Alien && AlienPredicates.areAliensSameHive(alien, targetedAlien = (Alien)livingEntity);
    }

    public static boolean areAliensSameHive(@NotNull Alien alien, @NotNull Alien otherAlien) {
        Option<UUID> hiveSignatureOption = alien.getHiveManager().signature();
        Option<UUID> otherHiveSignatureOption = otherAlien.getHiveManager().signature();
        return hiveSignatureOption.isSome() && otherHiveSignatureOption.isSome() && Objects.equals(hiveSignatureOption, otherHiveSignatureOption);
    }

    public static boolean isStandingOnResin(@NotNull LivingEntity potentialTarget) {
        BlockPos basePos = potentialTarget.blockPosition();
        BlockPos belowPos = basePos.below();
        BlockState baseBlockState = potentialTarget.level().getBlockState(basePos);
        BlockState belowBlockState = potentialTarget.level().getBlockState(belowPos);
        return baseBlockState.is(AVPBlockTags.RESIN) || belowBlockState.is(AVPBlockTags.RESIN);
    }

    private static boolean isHated(@NotNull Alien alien, @NotNull LivingEntity potentialTarget) {
        if (AVPPredicates.IS_IMMORTAL.test(potentialTarget)) {
            return false;
        }
        return potentialTarget.getType().is(AVPEntityTypeTags.HATED_BY_XENOMORPHS) || AlienPredicates.isTargetingHiveMember(alien, potentialTarget);
    }
}

