/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.data.worldgen;

import com.avp.common.data.worldgen.builder.AVPOreData;
import com.avp.common.registry.init.block.CoreBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class AVPOres {
    private static final RuleTest DEEPSLATE_ORE_REPLACEABLES_RULE = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
    private static final RuleTest GRAVEL_REPLACEABLES_RULE = new BlockMatchTest(Blocks.GRAVEL);
    private static final RuleTest STONE_ORE_REPLACEABLES_RULE = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
    private static final List<AVPOreData> ORE_DATA = new ArrayList<AVPOreData>();
    public static final AVPOreData BAUXITE_UPPER = AVPOres.create(AVPOres.builder("bauxite_ore_upper", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.BAUXITE_ORE.get().defaultBlockState())).count(75).heightRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)512))).veinSize(9).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData BAUXITE_MIDDLE = AVPOres.create(AVPOres.builder("bauxite_ore_middle", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.BAUXITE_ORE.get().defaultBlockState())).count(20).heightRange(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)9), (VerticalAnchor)VerticalAnchor.absolute((int)79))).veinSize(9).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData GALENA = AVPOres.create(AVPOres.builder("galena_ore", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.GALENA_ORE.get().defaultBlockState())).count(36).heightRange(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)9), (VerticalAnchor)VerticalAnchor.absolute((int)96))).veinSize(9).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData LEAD_SWAMP = AVPOres.create(AVPOres.builder("lead_ore_swamp", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.GALENA_ORE.get().defaultBlockState())).count(40).heightRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)64))).veinSize(9).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData LITHIUM = AVPOres.create(AVPOres.builder("lithium_ore", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.LITHIUM_ORE.get().defaultBlockState())).count(8).heightRange(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)9), (VerticalAnchor)VerticalAnchor.absolute((int)40))).veinSize(9).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData LITHIUM_DESERT = AVPOres.create(AVPOres.builder("lithium_ore_desert", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.LITHIUM_ORE.get().defaultBlockState())).count(20).heightRange(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)9), (VerticalAnchor)VerticalAnchor.absolute((int)64))).veinSize(6).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData MONAZITE = AVPOres.create(AVPOres.builder("monazite_ore", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.MONAZITE_ORE.get().defaultBlockState())).count(2).heightRange(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)16))).veinSize(6).normalizedAirDiscardChance(0.5f));
    public static final AVPOreData MONAZITE_JUNGLE = AVPOres.create(AVPOres.builder("monazite_ore_jungle", OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.MONAZITE_ORE.get().defaultBlockState())).count(15).heightRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-48), (VerticalAnchor)VerticalAnchor.absolute((int)48))).veinSize(6).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData SILICON_GRAVEL = AVPOres.create(AVPOres.builder("silicon_gravel", OreConfiguration.target((RuleTest)GRAVEL_REPLACEABLES_RULE, (BlockState)CoreBlocks.SILICA_GRAVEL.get().defaultBlockState())).count(25).heightRange(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)80))).veinSize(13).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData TITANIUM_LOWER = AVPOres.create(AVPOres.builder("titanium_ore_lower", OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.DEEPSLATE_TITANIUM_ORE.get().defaultBlockState())).count(10).heightRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-128), (VerticalAnchor)VerticalAnchor.absolute((int)0))).veinSize(9).normalizedAirDiscardChance(0.0f));
    private static final List<OreConfiguration.TargetBlockState> ZINC_TARGETS = List.of(OreConfiguration.target((RuleTest)DEEPSLATE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.DEEPSLATE_ZINC_ORE.get().defaultBlockState()), OreConfiguration.target((RuleTest)STONE_ORE_REPLACEABLES_RULE, (BlockState)CoreBlocks.ZINC_ORE.get().defaultBlockState()));
    public static final AVPOreData ZINC = AVPOres.create(AVPOres.builder("zinc_ore", ZINC_TARGETS).count(16).heightRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-16), (VerticalAnchor)VerticalAnchor.absolute((int)112))).veinSize(10).normalizedAirDiscardChance(0.0f));
    public static final AVPOreData ZINC_DRIPSTONE_CAVES = AVPOres.create(AVPOres.builder("zinc_ore_dripstone_caves", ZINC_TARGETS).count(16).heightRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-16), (VerticalAnchor)VerticalAnchor.absolute((int)112))).veinSize(20).normalizedAirDiscardChance(0.0f));

    public static List<AVPOreData> getAll() {
        return Collections.unmodifiableList(ORE_DATA);
    }

    private static AVPOreData.Builder builder(String name, OreConfiguration.TargetBlockState targetBlockState) {
        return AVPOres.builder(name, List.of(targetBlockState));
    }

    private static AVPOreData.Builder builder(String name, List<OreConfiguration.TargetBlockState> targetBlockStates) {
        return AVPOreData.builder(name, targetBlockStates).biomeFilter(BiomeFilter.biome()).spread();
    }

    private static AVPOreData create(AVPOreData.Builder builder) {
        AVPOreData data = builder.build();
        ORE_DATA.add(data);
        return data;
    }
}

