/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal.combat;

import com.lib.common.data.Cooldown;
import java.time.Duration;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.jetbrains.annotations.NotNull;

public class DelayedAttackGoal
extends MeleeAttackGoal {
    private final Runnable attackAnimationRunnable;
    private final Cooldown attackAnimationCooldown;
    private boolean ranAttackAnimation;

    public DelayedAttackGoal(PathfinderMob mob, double speedModifier, boolean bl, int delayTicksBeforeAttack, Runnable attackAnimationRunnable) {
        super(mob, speedModifier, bl);
        this.attackAnimationCooldown = Cooldown.withCooldownTime("attackAnimationCooldownInTicks", Duration.ofMillis((long)delayTicksBeforeAttack * 50L));
        this.attackAnimationRunnable = attackAnimationRunnable;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void tick() {
        super.tick();
        this.attackAnimationCooldown.tick();
        if (this.mob.getTarget() != null && this.ranAttackAnimation && !this.attackAnimationCooldown.isActive() && this.mob.isWithinMeleeAttackRange(this.mob.getTarget()) && this.mob.getSensing().hasLineOfSight((Entity)this.mob.getTarget())) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)this.mob.getTarget());
            this.ranAttackAnimation = false;
        }
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity target) {
        if (!this.ranAttackAnimation && this.canPerformAttack(target)) {
            this.attackAnimationRunnable.run();
            this.ranAttackAnimation = true;
            this.attackAnimationCooldown.reset();
        }
    }
}

