/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal.combat;

import com.avp.common.util.ItemGoalUtil;
import com.predator.common.gameplay.item.ShurikenItem;
import com.predator.common.gameplay.item.SmartDiscItem;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.pathfinder.Path;

public class UseItemGoal
extends Goal {
    private final int delayTicksBeforeAttack;
    private int ticksUntilNextAttack;
    private int delayBeforeAttack;
    private long lastCanUseCheck;
    private final PathfinderMob entity;
    private final Runnable attackAnimationRunnable;
    private boolean triggeredAttackAnimation;
    private Path path;

    public UseItemGoal(PathfinderMob entity, Runnable attackAnimationRunnable) {
        this.entity = entity;
        this.delayTicksBeforeAttack = 1;
        this.attackAnimationRunnable = attackAnimationRunnable;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        long gameTime = this.entity.level().getGameTime();
        if (gameTime - this.lastCanUseCheck < 20L) {
            return false;
        }
        if (this.entity.getTarget() != null) {
            this.path = this.entity.getNavigation().createPath((Entity)this.entity.getTarget(), 0);
        }
        if (this.entity.getTarget() != null && this.entity.isWithinMeleeAttackRange(this.entity.getTarget())) {
            return false;
        }
        return !this.entity.getMainHandItem().isEmpty() && this.entity.getTarget() != null && this.entity.hasLineOfSight((Entity)this.entity.getTarget());
    }

    public boolean canContinueToUse() {
        if (this.entity.getTarget() != null && this.entity.isWithinMeleeAttackRange(this.entity.getTarget())) {
            return false;
        }
        return !this.entity.getMainHandItem().isEmpty() && this.entity.getTarget() != null && this.entity.hasLineOfSight((Entity)this.entity.getTarget());
    }

    public void start() {
        if (this.entity.getHealth() > this.entity.getMaxHealth() / 2.0f) {
            this.entity.getNavigation().moveTo(this.path, (double)0.6f);
        }
        this.entity.startUsingItem(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.entity, (Item)this.entity.getMainHandItem().getItem()));
        this.entity.setAggressive(true);
        this.delayBeforeAttack = 0;
    }

    public void stop() {
        LivingEntity livingEntity = this.entity.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingEntity)) {
            this.entity.setTarget(null);
        }
        this.entity.setAggressive(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingEntity = this.entity.getTarget();
        if (livingEntity != null) {
            this.entity.getLookControl().setLookAt((Entity)this.entity.getTarget(), 180.0f, 180.0f);
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingEntity);
        }
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.canPerformAttack(target)) {
            if (this.delayBeforeAttack > 0) {
                if (this.delayBeforeAttack == this.delayTicksBeforeAttack && !this.triggeredAttackAnimation) {
                    this.attackAnimationRunnable.run();
                    this.triggeredAttackAnimation = true;
                }
                --this.delayBeforeAttack;
            } else {
                this.resetAttackCooldown();
                this.entity.swing(InteractionHand.MAIN_HAND);
                if (this.entity.getMainHandItem().getItem() instanceof ShurikenItem) {
                    ItemGoalUtil.shootShuriken(this.entity);
                }
                if (this.entity.getMainHandItem().getItem() instanceof SmartDiscItem) {
                    ItemGoalUtil.shootSmartDisc(this.entity);
                }
                this.triggeredAttackAnimation = false;
            }
        } else {
            this.delayBeforeAttack = this.adjustedTickDelay(10);
            this.triggeredAttackAnimation = false;
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity livingEntity) {
        return this.isTimeToAttack() && this.entity.getSensing().hasLineOfSight((Entity)livingEntity);
    }
}

