/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class ExplosionCursor {
    private final Explosion explosion;
    private final Direction direction;
    private int x;
    private int y;
    private int depth;

    public ExplosionCursor(Explosion explosion, Direction direction) {
        this.explosion = explosion;
        this.direction = direction;
    }

    public BlockPos next() {
        BlockPos centerPos = this.explosion.config().centerBlockPosition();
        BlockPos wallCenterPos = centerPos.relative(this.direction, this.depth);
        BlockPos wallTopLeftCorner = wallCenterPos.relative(this.getPerpendicularDirection1(), this.depth).relative(this.getPerpendicularDirection2(), this.depth);
        BlockPos currentPos = wallTopLeftCorner.offset(this.getXOffset(), this.getYOffset(), this.getZOffset());
        this.advanceCursor();
        return currentPos;
    }

    private void advanceCursor() {
        ++this.x;
        if (this.x > this.depth * 2) {
            this.x = 0;
            ++this.y;
        }
        if (this.y > this.depth * 2) {
            this.y = 0;
            ++this.depth;
        }
    }

    public boolean canExpandFurther() {
        return this.depth < this.explosion.config().directionToRadiusMap().get(this.direction);
    }

    private Direction getPerpendicularDirection1() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.SOUTH -> Direction.WEST;
            case Direction.EAST, Direction.WEST -> Direction.UP;
            case Direction.UP, Direction.DOWN -> Direction.NORTH;
        };
    }

    private Direction getPerpendicularDirection2() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.SOUTH -> Direction.UP;
            case Direction.EAST, Direction.WEST -> Direction.NORTH;
            case Direction.UP, Direction.DOWN -> Direction.WEST;
        };
    }

    private int getXOffset() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.SOUTH -> this.x;
            case Direction.EAST, Direction.WEST -> 0;
            case Direction.UP, Direction.DOWN -> this.x;
        };
    }

    private int getYOffset() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> -this.y;
            case Direction.UP, Direction.DOWN -> 0;
        };
    }

    private int getZOffset() {
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.SOUTH -> 0;
            case Direction.EAST, Direction.WEST -> this.x;
            case Direction.UP, Direction.DOWN -> this.y;
        };
    }
}

