/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion.nuke;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.registry.init.block.CoreBlocks;
import com.avp.common.registry.key.AVPBiomeKeys;
import com.avp.common.util.ExplosionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public class NuclearExplosionEffects {
    private static final Map<Block, Block> BLOCK_TRANSFORMER_MAP = Map.ofEntries(Map.entry(Blocks.ANDESITE, Blocks.GRAVEL), Map.entry(Blocks.DEEPSLATE, Blocks.COBBLED_DEEPSLATE), Map.entry(Blocks.DIORITE, Blocks.SAND), Map.entry(Blocks.GRANITE, Blocks.RED_SAND), Map.entry(Blocks.GRASS_BLOCK, Blocks.COARSE_DIRT), Map.entry(Blocks.LAVA, Blocks.MAGMA_BLOCK), Map.entry(Blocks.STONE, Blocks.COBBLESTONE));
    private final Set<ChunkPos> visitedChunks = new HashSet<ChunkPos>();

    public void apply(Explosion explosion, BlockPos pos) {
        BlockPos centerPos = explosion.config().centerBlockPosition();
        ServerLevel level = explosion.level();
        int x = pos.getX() - centerPos.getX();
        int y = pos.getY() - centerPos.getY();
        int z = pos.getZ() - centerPos.getZ();
        int radiusX = explosion.config().largestRadius(Direction.Axis.X);
        int radiusZ = explosion.config().largestRadius(Direction.Axis.Z);
        int radiusYDown = explosion.config().radius(Direction.DOWN);
        int radiusYUp = explosion.config().radius(Direction.UP);
        double yScaleFactor = (double)(radiusX + radiusZ) / 2.0 / (double)Math.max(radiusYUp, radiusYDown);
        double horizontalDistance = ExplosionUtil.getNormalizedHorizontalDistance(explosion, x, z);
        double verticalDistance = ExplosionUtil.getNormalizedVerticalDistance(explosion, y) * yScaleFactor;
        double distance = horizontalDistance + verticalDistance;
        int flags = 34;
        float rand = level.random.nextFloat();
        BlockPos posBelow = pos.below();
        BlockState blockState = level.getBlockState(pos);
        if (distance > 0.98) {
            int rand2;
            Block transformedBlock = (double)rand > horizontalDistance ? Blocks.BLACKSTONE : (blockState.is(BlockTags.DIRT) ? Blocks.BASALT : (blockState.is(BlockTags.SAND) || blockState.is(Blocks.SANDSTONE) || blockState.is(Blocks.RED_SANDSTONE) ? ((rand2 = level.random.nextInt(100)) < 66 ? CoreBlocks.TRINITITE_BLOCK.get() : Blocks.MAGMA_BLOCK) : BLOCK_TRANSFORMER_MAP.getOrDefault(blockState.getBlock(), Blocks.BASALT)));
            if (blockState.isSolidRender((BlockGetter)level, pos) && level.getRandom().nextInt(10) < 2) {
                level.setBlock(pos.above(), (BlockState)CoreBlocks.ASH_BLOCK.get().defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(1)), flags);
            }
            level.setBlock(pos, transformedBlock.defaultBlockState(), flags);
        } else if (distance > 0.75) {
            if ((double)rand > horizontalDistance) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), flags);
            } else {
                level.setBlock(pos, Blocks.FIRE.defaultBlockState(), flags);
            }
        } else {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), flags);
        }
        level.sendParticles((ParticleOptions)ParticleTypes.FLASH, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        this.tryTransformChunkBiome(level, pos);
    }

    private void tryTransformChunkBiome(ServerLevel level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                ChunkPos expandedChunkPos = new ChunkPos(chunkPos.x + dx, chunkPos.z + dz);
                if (this.visitedChunks.contains(expandedChunkPos)) continue;
                Holder.Reference biome = level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(AVPBiomeKeys.NUKED_BIOME);
                this.setBiome(level, new BlockPos(expandedChunkPos.getMinBlockX(), 0, expandedChunkPos.getMinBlockZ()), (Holder<Biome>)biome);
                level.getChunkSource().chunkMap.resendBiomesForChunks(List.of(level.getChunk(expandedChunkPos.x, expandedChunkPos.z)));
                this.visitedChunks.add(expandedChunkPos);
            }
        }
    }

    private void setBiome(ServerLevel level, BlockPos pos, Holder<Biome> holder) {
        LevelChunk chunk = level.getChunkAt(pos);
        chunk.fillBiomesFromNoise((i, j, k, sampler) -> {
            int l = QuartPos.toBlock((int)i);
            int m = QuartPos.toBlock((int)j);
            int n = QuartPos.toBlock((int)k);
            Holder holder2 = chunk.getNoiseBiome(i, j, k);
            return holder;
        }, level.getChunkSource().randomState().sampler());
        chunk.setUnsaved(true);
    }
}

