/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.network;

import com.avp.client.network.AVPClientListener;
import com.avp.common.network.NetworkHandler;
import com.avp.common.network.ServerListener;
import com.avp.common.network.packet.C2SGunHitResultsPayload;
import com.avp.common.network.packet.C2SGunReloadPayload;
import com.avp.common.network.packet.C2SPlayerToggleCrawlPayload;
import com.avp.common.network.packet.S2CBulletHitBlockPayload;
import com.avp.common.network.packet.S2CEntityDataSyncPayload;
import com.avp.common.network.packet.S2CGunRecoilPayload;
import com.avp.service.Services;

public class AVPServerPacketHandlerRegistry {
    public static void initialize() {
        AVPServerPacketHandlerRegistry.registerServerBoundPacketHandlers();
        AVPServerPacketHandlerRegistry.registerClientBoundPacketHandlers();
    }

    private static void registerServerBoundPacketHandlers() {
        Services.REGISTRY.registerPacketHandlers(new NetworkHandler.FromClient<C2SGunHitResultsPayload>(C2SGunHitResultsPayload.TYPE, C2SGunHitResultsPayload.CODEC, ServerListener::handleGunHitResultsPayload));
        Services.REGISTRY.registerPacketHandlers(new NetworkHandler.FromClient<C2SGunReloadPayload>(C2SGunReloadPayload.TYPE, C2SGunReloadPayload.CODEC, ServerListener::handleGunReloadPayload));
        Services.REGISTRY.registerPacketHandlers(new NetworkHandler.FromClient<C2SPlayerToggleCrawlPayload>(C2SPlayerToggleCrawlPayload.TYPE, C2SPlayerToggleCrawlPayload.CODEC, ServerListener::handlePlayerToggleCrawlPayload));
    }

    private static void registerClientBoundPacketHandlers() {
        Services.REGISTRY.registerPacketHandlers(new NetworkHandler.FromServer<S2CBulletHitBlockPayload>(S2CBulletHitBlockPayload.TYPE, S2CBulletHitBlockPayload.CODEC, (payload, player) -> AVPClientListener.handleBulletHitBlockPayload(payload)));
        Services.REGISTRY.registerPacketHandlers(new NetworkHandler.FromServer<S2CGunRecoilPayload>(S2CGunRecoilPayload.TYPE, S2CGunRecoilPayload.CODEC, AVPClientListener::handleGunRecoil));
        Services.REGISTRY.registerPacketHandlers(new NetworkHandler.FromServer<S2CEntityDataSyncPayload>(S2CEntityDataSyncPayload.TYPE, S2CEntityDataSyncPayload.CODEC, AVPClientListener::handleEntityDataSync));
    }
}

