/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.registry;

import com.avp.AVP;
import com.avp.common.registry.AVPDeferredHolder;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class AVPRegistryValidation {
    public static <T> void throwIfMissingEntries(Collection<AVPDeferredHolder<? extends T>> entries, Predicate<T> contains, Function<T, String> descriptionIdSupplier, String message) {
        List<Object> unhandledEntries = entries.stream().map(AVPDeferredHolder::get).filter(Predicate.not(contains)).toList();
        if (!unhandledEntries.isEmpty()) {
            String unhandledBlocksStrings = String.join((CharSequence)"\n", unhandledEntries.stream().map(descriptionIdSupplier).toList());
            AVP.LOGGER.error("Detected {} unhandled entries. Entries:\n{}", (Object)unhandledEntries.size(), (Object)unhandledBlocksStrings);
            throw new IllegalStateException(message);
        }
    }
}

